<?php
/*-----------------------------------------------------------------------
    $Id: search_replace_iso-8859-1.php 1323 2010-09-16 14:48:36Z web28 $
	
    Zeichenkodierung: ISO-8859-1
   
   Version 1.06 rev.04 (c) by web28  - www.rpa-com.de   
------------------------------------------------------------------------*/

function shopstat_getRegExps(&$search, &$replace)
{
    $search     = array(
						"'\s&\s'",                	//--Kaufmnnisches Und mit Blanks muss raus
						"'[\r\n\s]+'",	          	// strip out white space
						"'&(quote|#34);'i",	      	//--Anfhrungszeichen oben replace html entities
						"'&(amp|#38);'i",        	//--Ampersand-Zeichen, kaufmnnisches Und
						"'&(lt|#60);'i",	     	//--ffnende spitze Klammer
						"'&(gt|#62);'i",	     	//--schlieende spitze Klammer
						"'&(nbsp|#160);'i",	      	//--Erzwungenes Leerzeichen					
						//BOF - web28 - 2010-04-16 - UFT-8 kompatibel +  Eingetragene Marke, Trademark, Eurozeichen
						"'&(iexcl|#161);|'i", 		//umgekehrtes Ausrufezeichen
						"'&(cent|#162);|'i", 		//Cent-Zeichen
						"'&(pound|#163);|'i", 		//Pfund-Zeichen
						"'&(curren|#164);|'i",   	//Whrungszeichen--currency 
						"'&(yen|#165);|'i",   		//Yen  wird zu Yen
						"'&(brvbar|#166);|'i",		//durchbrochener Strich
						"'&(sect|#167);|'i",		//Paragraph-Zeichen
						"'&(copy|#169);|'i",		//Copyright-Zeichen 					
						"'&(reg|#174);|'i",		//Eingetragene Marke wird zu -R-
						"'&(deg|#176);|'i",		//Grad-Zeichen -- degree wird zu -Grad-
						"'&(plusmn|#177);|'i",		//Plusminus-Zeichen
						"'&(sup2|#178);|'i",	    //Hoch-2-Zeichen 
						"'&(sup3|#179);|'i", 		//Hoch-3-Zeichen 
						//"'&(acute|#180);'i", 		// Akut (accent aigu, acute) ### NICHT in iso-8859-1 enthalten ###
						"'&(micro|#181);|'i",		//Mikro-Zeichen
						"'&(trade|#8482);'i",   	//--Trademark wird zu -TM-  ### NICHT in iso-8859-1 enthalten ###
						"'&(euro|#8364);'i",   		//--Eurozeichen wird zu EUR ### NICHT in iso-8859-1 enthalten ###
						"'&(laquo|#171);|'i", 	 	//-- Left angle quotes Left Winkel Zitate
						"'&(raquo|#187);|'i", 		//--Right angle quotes Winkelgetriebe Zitate
						//BOF - web28 - 2010-05-13 - Benannte Zeichen fr Interpunktion
						"'&(ndash|#8211);'i", 	//-- Gedankenstrich Breite n 	### NICHT in iso-8859-1 enthalten ###
						"'&(mdash|#8212);'i", 	//-- Gedankenstrich Breite m 	### NICHT in iso-8859-1 enthalten ###
						"'&(lsquo|#8216);'i", 	//-- einfaches Anfhrungszeichen links 	### NICHT in iso-8859-1 enthalten ###
						"'&(rsquo|#8217);'i", 	//-- einfaches Anfhrungszeichen rechts 	### NICHT in iso-8859-1 enthalten ###
						"'&(sbquo|#8218);'i", 	//-- Einfaches, gekrmmtes Anfhrungszeichen unten 	### NICHT in iso-8859-1 enthalten ###
						"'&(ldquo|#8220);'i", 	//-- doppeltes Anfhrungszeichen links  ### NICHT in iso-8859-1 enthalten ###
						"'&(rdquo|#8221);'i", 	//-- doppeltes Anfhrungszeichen rechts  ### NICHT in iso-8859-1 enthalten ###
						"'&(bdquo|#8222);'i", 	//-- Doppelte Anfhrungszeichen links unten   ### NICHT in iso-8859-1 enthalten ###
						//EOF - web28 - 2010-05-13 - Benannte Zeichen fr Interpunktion
						//EOF - web28 - 2010-04-16 - UFT-8 kompatibel +  Eingetragene Marke, Trademark, Eurozeichen
						"'&'", 	                  //--Kaufmnnisches Und 
						"'%'", 	                  //--Prozent muss weg
						"/[\[\({]/",              //--ffnende Klammern nach Bindestriche
						"/[\)\]\}]/",             //--schliessende Klammern weg
						"//",                    //--Umlaute etc.
						"//",                    //--Umlaute etc.
						"//",                    //--Umlaute etc.
						"//",                    //--Umlaute etc.
						"//",                    //--Umlaute etc.
						"//",                    //--Umlaute etc.
						"//",                    //--Umlaute etc.						
						"/'|\"||`/",               //--Anfhrungszeichen weg.						
						"/[:,\.!?\*\+]/"         	//--Doppelpunkte, Komma, Punkt etc. weg. 
                        );
						
	
	if (SPECIAL_CHAR_FR) {					
	$search2 = array(	//BOF  - web28 - 2010-05-12 - Franzsisch
						"'&(Agrave|#192);|'i",		// Capital A-grave Capital A-Grab
						"'&(agrave|#224);|'i",		//Lowercase a-grave Kleinbuchstaben a-Grab
						"'&(Acirc|#194);|'i",		//Capital A-circumflex Capital A-Zirkumflex
						"'&(acirc|#226);|'i",		//Lowercase a-circumflex Kleinbuchstaben a-Zirkumflex
						"'&(AElig|#198);|'i",		//Capital AE Ligature Capital AE Ligature
						"'&(aelig|#230);|'i",		//Lowercase AE Ligature Kleinbuchstabe ae
						"'&(Ccedil|#199);|'i",		//Capital C-cedilla Capital-C Cedille
						"'&(ccedil|#231);|'i",		//Lowercase c-cedilla Kleinbuchstaben c-Cedille
						"'&(Egrave|#200);|'i",		//Capital E-grave Capital E-Grab
						"'&(egrave|#232);|'i",		//Lowercase e-grave Kleinbuchstaben e-Grab
						"'&(Eacute|#201);|'i",		//Capital E-acute E-Capital akuten
						"'&(eacute|#233);|'i",		//Lowercase e-acute Kleinbuchstaben e-acute
						"'&(Ecirc|#202);|'i",		//Capital E-circumflex E-Capital circumflexa
						"'&(ecirc|#234);|'i",		//Lowercase e-circumflex Kleinbuchstaben e-Zirkumflex
						"'&(Euml|#203);|'i",		//Capital E-umlaut Capital E-Umlaut
						"'&(euml|#235);|'i",		//Lowercase e-umlaut Kleinbuchstaben e-Umlaut
						"'&(Icirc|#206);|'i",		//Capital I-circumflex Capital I-Zirkumflex
						"'&(icirc|#238);|'i",		//Lowercase i-circumflex Kleinbuchstaben i-Zirkumflex
						"'&(Iuml|#207);|'i",		//Capital I-umlaut Capital I-Umlaut
						"'&(iuml|#239);|'i",		//Lowercase i-umlaut Kleinbuchstaben i-Umlaut
						"'&(Ocirc|#212);|'i",		//Capital O-circumflex O-Capital circumflexa
						"'&(ocirc|#244);|'i",		//Lowercase o-circumflex Kleinbuchstabe o-Zirkumflex
						"'&(OElig|#338);'i",		//Capital OE ligature Capital OE Ligatur ### NICHT in iso-8859-1 enthalten ###
						"'&(oelig|#339);'i",		//Lowercase oe ligature Kleinbuchstaben oe Ligatur ### NICHT in iso-8859-1 enthalten ###
						"'&(Ugrave|#217);|'i",		//Capital U-grave Capital U-Grab
						"'&(ugrave|#249);|'i",		//Lowercase u-grave Kleinbuchstaben u-Grab
						"'&(Ucirc|#219);|'i",		//Capital U-circumflex Capital U-Zirkumflex
						"'&(ucirc|#251);|'i",		//Lowercase U-circumflex Kleinbuchstaben U-Zirkumflex
						"'&(Yuml|#376);'i",			//Groes Y mit Diaeresis ### NICHT in iso-8859-1 enthalten ###
						"'&(yuml|#255);|'i"		//Kleines y mit Diaeresis
						//EOF - web28 - 2010-05-12 - Franzsisch	
						);
						
	$search = array_merge($search,$search2);
	//echo print_r($search);
	}
	
	if (SPECIAL_CHAR_ES) {
	$search3 = array(	//BOF - web28 - 2010-08-13 - Spanisch
						"'&(Aacute|#193);|'i",		//Groes A mit Akut
						"'&(aacute|#225);|'i",		//Kleines a mit Akut
						"'&(Iacute|#205);|'i",		//Groes I mit Akut
						"'&(iacute|#227);|'i",		//Kleines i mit Akut
						"'&(Ntilde|#209);|'i",		//Groes N mit Tilde
						"'&(ntilde|#241);|'i",		//Kleines n mit Tilde
						"'&(Oacute|#211);|'i",		//Groes O mit Akut
						"'&(oacute|#243);|'i",		//Kleines o mit Akut
						"'&(Uacute|#218);|'i",		//Groes U mit Akut
						"'&(uacute|#250);|'i",		//Kleines u mit Akut
						"'&(ordf|#170);|'i",		//Weibliche Ordnungszahl
						"'&(ordm|#186);|'i",		//mnnliche Ordnungszahl
						"'&(iexcl|#161);|'i",		//umgekehrtes Ausrufungszeichen
						"'&(iquest|#191);|'i",		//umgekehrtes Fragezeichen
						//EOF - web28 - 2010-08-13 - Spanisch
						//EOF - web28 - 2010-05-12 - Portugiesisch	
						"'&(Atilde|#195);|'i",		//Groes A mit Tilde
						"'&(atilde|#227);|'i",		//Kleines a mit Tilde
						"'&(Otilde|#213);|'i",		//Groes O mit Tilde
						"'&(otilde|#245);|'i",		//Kleines o mit Tilde
						//BOF - web28 - 2010-05-12 - Portugiesisch
						//BOF - web28 - 2010-05-12 - Italienisch
						"'&(Igrave|#204);|'i",		//Groes I mit Grave
						"'&(igrave|#236);|'i"		//Kleines i mit Grave						
						//EOF - web28 - 2010-05-12 - Italienisch
						);
	
	$search = array_merge($search,$search3);
	}
	
    if (SPECIAL_CHAR_MORE) {	
	$search4 = array(	//BOF - web28 - 2010-05-12 - Weitere Sonderzeichen
						"'&(Ograve|#210);|'i",		//Groes O mit Grave
						"'&(ograve|#242);|'i",		//Kleines o mit Grave
						"'&(Ograve|#210);|'i",		//Groes O mit Grave
						"'&(ograve|#242);|'i",		//Kleines o mit Grave
						"'&(Oslash|#216);|'i",		//Groes O mit Schrgstrich
						"'&(oslash|#248);|'i",		//Kleines o mit Schrgstrich
						"'&(Aring|#197);|'i",		//Groes A mit Ring (Krouzek)
						"'&(aring|#229);|'i",		//Kleines a mit Ring (Krouzek)
						"'&(Scaron|#352);|'i",		//Groes S mit Caron (Hatschek)
						"'&(scaron|#353);|'i",		//Kleines s mit Caron (Hatschek)
						"'&(THORN|#222);|'i",		//Groes Thorn (islndischer Buchstabe)
						"'&(thorn|#254);|'i",		//Kleines thorn (islndischer Buchstabe)
						"'&(divide|#247);|'i",		//Divisions-Zeichen ("Geteilt durch ...")
						"'&(times|#215);|'i",		//Multiplikationszeichen; "Multipliziert mit ..."
						"'&(ETH|#272;)|'i",		//Groes D mit Querstrich (islndischer Buchstabe)
						"'&(eth|#273;)|'i",		//Kleines d mit Querstrich (islndischer Buchstabe)
						"'&(Yacute|#221;)|'i",		//Groes Y mit Akut
						"'&(yacute|#253;)|'i",		//Kleines y mit Akut						
						//EOF - web28 - 2010-05-12 - Weitere Sonderzeichen
						);
						
	$search = array_merge($search,$search4);
	//echo print_r($search);
	}
	
//*****************************************************************
    
	$replace    = array(
						"-",		//--Kaufmnnisches Und mit Blanks
						"-",		// strip out white space
						"-",		//--Anfhrungszeichen oben 
						"-",		//--Ampersand-Zeichen, kaufmnnisches Und
						"-",		//--ffnende spitze Klammer
						"-",		//--schlieende spitze Klammer
						"",			//--Erzwungenes Leerzeichen
						//BOF - web28 - 2010-04-16 - UFT-8 kompatibel +  Eingetragene Marke, Trademark, Eurozeichen
						"", 		//chr(161), //umgekehrtes Ausrufezeichen
						"ct", 		//chr(162), //Cent-Zeichen
						"GBP", 		//chr(163), //Pfund-Zeichen
						"", 		//chr(164), //Whrungszeichen--currency 
						"Yen", 		//chr(165), //Yen-Zeichen
						"",			//chr(166),durchbrochener Strich
						"",			//chr(167),Paragraph-Zeichen
						"",			//chr(169),Copyright-Zeichen											
						"", 		//chr(174), //Eingetragene Marke
						"-GRAD-", 	//chr(176), //Grad-Zeichen
						"",			//chr(177) Plusminus-Zeichen
						"", 		//chr(178) Hoch-2-Zeichen 
						"", 		//chr(179) Hoch-3-Zeichen
						//"",			//chr(180) Akut (accent aigu, acute) ### NICHT in iso-8859-15 enthalten ###
						"", 		//chr(181) Mikro-Zeichen
						"-TM-",		//--Trademark wird zu -TM-
						"-EUR-",		//--Eurozeichen wird zu EUR
						"",			//chr(171) -- Left angle quotes Left Winkel Zitate
						"",			//chr(187) -- Right angle quotes Right Winkel Zitate
						//BOF - web28 - 2010-05-13 - Benannte Zeichen fr Interpunktion
						"-", 		//-- Gedankenstrich Breite n 	
						"-", 		//-- Gedankenstrich Breite m 	
						"", 		//-- einfaches Anfhrungszeichen links 	
						"", 		//-- einfaches Anfhrungszeichen rechts 	
						"", 		//-- einfaches low-9-Zeichen 	
						"", 		//-- doppeltes Anfhrungszeichen links 
						"", 		//-- doppeltes Anfhrungszeichen rechts 
						"", 		//-- doppeltes low-9-Zeichen rechts
						//EOF - web28 - 2010-05-13 - Benannte Zeichen fr Interpunktion	
						//EOF - web28 - 2010-04-16 - UFT-8 kompatibel +  Eingetragene Marke, Trademark, Eurozeichen
						"-",		//--Kaufmnnisches Und 
						"-",		//--Prozent 
			            "-",		//--ffnende Klammern
			            "",			//--schliessende Klammern 
			            "ss",		//--Umlaute etc.
			            "ae",		//--Umlaute etc.
			            "ue",		//--Umlaute etc.
			            "oe",		//--Umlaute etc.
			            "Ae",		//--Umlaute etc.
			            "Ue",		//--Umlaute etc.
			            "Oe",		//--Umlaute etc.											
						"",			//--Anfhrungszeichen 			
						"-"			//--Doppelpunkte, Komma, Punkt etc. 
                        );
						
	if (SPECIAL_CHAR_FR) {					
	$replace2 = array(	//BOF - web28 - 2010-05-12 - Franzsisch
						"A",		// Capital A-grave Capital A-Grab
						"a",		//Lowercase a-grave Kleinbuchstaben a-Grab
						"A",		//Capital A-circumflex Capital A-Zirkumflex
						"a",		//Lowercase a-circumflex Kleinbuchstaben a-Zirkumflex
						"AE",		//Capital AE Ligature Capital AE Ligature
						"ae",		//Lowercase AE Ligature Kleinbuchstabe ae
						"C",		//Capital C-cedilla Capital-C Cedille
						"c",		//Lowercase c-cedilla Kleinbuchstaben c-Cedille
						"E",		//Capital E-grave Capital E-Grab
						"e",		//Lowercase e-grave Kleinbuchstaben e-Grab
						"E",		//Capital E-acute E-Capital akuten
						"e",		//Lowercase e-acute Kleinbuchstaben e-acute
						"E",		//Capital E-circumflex E-Capital circumflexa
						"e",		//Lowercase e-circumflex Kleinbuchstaben e-Zirkumflex
						"E",		//Capital E-umlaut Capital E-Umlaut
						"e",		//Lowercase e-umlaut Kleinbuchstaben e-Umlaut
						"I",		//Capital I-circumflex Capital I-Zirkumflex
						"i",		//Lowercase i-circumflex Kleinbuchstaben i-Zirkumflex
						"I",		//Capital I-umlaut Capital I-Umlaut
						"i",		//Lowercase i-umlaut Kleinbuchstaben i-Umlaut
						"O",		//Capital O-circumflex O-Capital circumflexa
						"o",		//Lowercase o-circumflex Kleinbuchstabe o-Zirkumflex
						"OE",		//Capital OE ligature Capital OE Ligatur
						"oe",		//Lowercase oe ligature Kleinbuchstaben oe Ligatur
						"U",		//Capital U-grave Capital U-Grab
						"u",		//Lowercase u-grave Kleinbuchstaben u-Grab
						"U",		//Capital U-circumflex Capital U-Zirkumflex						
						"u",		//Lowercase U-circumflex Kleinbuchstaben U-Zirkumflex
						"Y",		//Groes Y mit Diaeresis
						"y"			//Kleines y mit Diaeresis
						//EOF - web28 - 2010-05-12 - Franzsisch
						);
						
	$replace = array_merge($replace,$replace2);
	}
	
	if (SPECIAL_CHAR_ES) {
	$replace3 = array(	//BOF - web28 - 2010-08-13 - Spanisch
						"A",		//Groes A mit Akut
						"a",		//Kleines a mit Akut
						"I",		//Groes I mit Akut
						"i",		//Kleines i mit Akut
						"N",		//Groes N mit Tilde
						"n",		//Kleines n mit Tilde
						"O",		//Groes O mit Akut
						"o",		//Kleines o mit Akut
						"U",		//Groes U mit Akut
						"u",		//Kleines u mit Akut
						"",			//Weibliche Ordnungszahl
						"",			//mnnliche Ordnungszahl
						"",			//umgekehrtes Ausrufungszeichen
						"",			//umgekehrtes Fragezeichen
						//EOF - web28 - 2010-08-13 - Spanisch
						//EOF - web28 - 2010-08-13 - Portugiesisch	
						"A",		//Groes A mit Tilde
						"a",		//Kleines a mit Tilde
						"O",		//Groes O mit Tilde
						"o",		//Kleines o mit Tilde
						//BOF - web28 - 2010-08-13 - Portugiesisch
						//BOF - web28 - 2010-08-13 - Italienisch
						"I",		//Groes I mit Grave
						"i"			//Kleines i mit Grave						
						//EOF - web28 - 2010-08-13 - Italienisch
						);
	
	$replace = array_merge($replace,$replace3);
	}
	
    if (SPECIAL_CHAR_MORE) {	
	$replace4 = array(	//BOF -web28 - 2010-09-16 - Weitere Sonderzeichen
						"O",		//Groes O mit Grave
						"o",		//Kleines o mit Grave
						"O",		//Groes O mit Grave
						"o",		//Kleines o mit Grave
						"O",		//Groes O mit Schrgstrich
						"o",		//Kleines o mit Schrgstrich
						"A",		//Groes A mit Ring (Krouzek)
						"a",		//Kleines a mit Ring (Krouzek)
						"S",		//Groes S mit Caron (Hatschek)
						"s",		//Kleines s mit Caron (Hatschek)
						"Th",		//Groes Thorn (islndischer Buchstabe)
						"th",		//Kleines thorn (islndischer Buchstabe)
						"-",		//Divisions-Zeichen ("Geteilt durch ...")
						"x",		//Multiplikationszeichen; "Multipliziert mit ..."
						"D",		//Groes D mit Querstrich (islndischer Buchstabe)
						"d",		//Kleines d mit Querstrich (islndischer Buchstabe)
						"Y",		//Groes Y mit Akut
						"y",		//Kleines y mit Akut						
						//EOF - web28 - 2010-09-16 - Weitere Sonderzeichen	
						);
						
	$replace = array_merge($replace,$replace4);
	}

}
?>