/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
define(["require","exports","jquery","../AbstractInteractableModule","TYPO3/CMS/Core/Ajax/AjaxRequest","TYPO3/CMS/Core/SecurityUtility","../../Renderable/FlashMessage","../../Renderable/InfoBox","../../Renderable/ProgressBar","../../Renderable/Severity","../../Router","bootstrap"],(function(t,a,e,s,n,i,o,d,l,c,p){"use strict";class g extends s.AbstractInteractableModule{constructor(){super(...arguments),this.selectorOutputContainer=".t3js-languagePacks-output",this.selectorContentContainer=".t3js-languagePacks-mainContent",this.selectorActivateLanguage=".t3js-languagePacks-activateLanguage",this.selectorActivateLanguageIcon="#t3js-languagePacks-activate-icon",this.selectorAddLanguageToggle=".t3js-languagePacks-addLanguage-toggle",this.selectorLanguageInactive=".t3js-languagePacks-inactive",this.selectorDeactivateLanguage=".t3js-languagePacks-deactivateLanguage",this.selectorDeactivateLanguageIcon="#t3js-languagePacks-deactivate-icon",this.selectorUpdate=".t3js-languagePacks-update",this.selectorLanguageUpdateIcon="#t3js-languagePacks-languageUpdate-icon",this.selectorExtensionPackMissesIcon="#t3js-languagePacks-extensionPack-misses-icon",this.selectorNotifications=".t3js-languagePacks-notifications",this.activeLanguages=[],this.activeExtensions=[],this.packsUpdateDetails={toHandle:0,handled:0,updated:0,new:0,failed:0},this.notifications=[]}static pluralize(t,a="pack",e="s",s=0){return 1!==t&&1!==s?a+e:a}initialize(t){this.currentModal=t,this.getData(),t.on("click",this.selectorAddLanguageToggle,()=>{t.find(this.selectorContentContainer+" "+this.selectorLanguageInactive).toggle()}),t.on("click",this.selectorActivateLanguage,t=>{const a=e(t.target).closest(this.selectorActivateLanguage).data("iso");t.preventDefault(),this.activateLanguage(a)}),t.on("click",this.selectorDeactivateLanguage,t=>{const a=e(t.target).closest(this.selectorDeactivateLanguage).data("iso");t.preventDefault(),this.deactivateLanguage(a)}),t.on("click",this.selectorUpdate,t=>{const a=e(t.target).closest(this.selectorUpdate).data("iso"),s=e(t.target).closest(this.selectorUpdate).data("extension");t.preventDefault(),this.updatePacks(a,s)})}getData(){const t=this.getModalBody();new n(p.getUrl("languagePacksGetData")).get({cache:"no-cache"}).then(async a=>{const s=await a.resolve();if(!0===s.success){this.activeLanguages=s.activeLanguages,this.activeExtensions=s.activeExtensions,t.empty().append(s.html);const a=t.parent().find(this.selectorContentContainer);a.empty(),a.append(this.languageMatrixHtml(s)),a.append(this.extensionMatrixHtml(s)),e('[data-toggle="tooltip"]').tooltip({container:a})}else{const t=d.render(c.error,"Something went wrong","");this.addNotification(t)}this.renderNotifications()},a=>{p.handleAjaxError(a,t)})}activateLanguage(t){const a=this.getModalBody(),e=this.findInModal(this.selectorOutputContainer),s=l.render(c.loading,"Loading...","");e.empty().append(s),this.getNotificationBox().empty(),new n(p.getUrl()).post({install:{action:"languagePacksActivateLanguage",token:this.getModuleContent().data("language-packs-activate-language-token"),iso:t}}).then(async t=>{const a=await t.resolve();if(e.empty(),!0===a.success&&Array.isArray(a.status))a.status.forEach(t=>{const a=d.render(t.severity,t.title,t.message);this.addNotification(a)});else{const t=o.render(c.error,"Something went wrong","");this.addNotification(t)}this.getData()},t=>{p.handleAjaxError(t,a)})}deactivateLanguage(t){const a=this.getModalBody(),e=this.findInModal(this.selectorOutputContainer),s=l.render(c.loading,"Loading...","");e.empty().append(s),this.getNotificationBox().empty(),new n(p.getUrl()).post({install:{action:"languagePacksDeactivateLanguage",token:this.getModuleContent().data("language-packs-deactivate-language-token"),iso:t}}).then(async t=>{const a=await t.resolve();if(e.empty(),!0===a.success&&Array.isArray(a.status))a.status.forEach(t=>{const a=d.render(t.severity,t.title,t.message);this.addNotification(a)});else{const t=o.render(c.error,"Something went wrong","");this.addNotification(t)}this.getData()},t=>{p.handleAjaxError(t,a)})}updatePacks(t,a){const s=this.findInModal(this.selectorOutputContainer),i=this.findInModal(this.selectorContentContainer),o=void 0===t?this.activeLanguages:[t];let d=!0,l=this.activeExtensions;void 0!==a&&(l=[a],d=!1),this.packsUpdateDetails={toHandle:o.length*l.length,handled:0,updated:0,new:0,failed:0},s.empty().append(e("<div>",{class:"progress"}).append(e("<div>",{class:"progress-bar progress-bar-info",role:"progressbar","aria-valuenow":0,"aria-valuemin":0,"aria-valuemax":100,style:"width: 0;"}).append(e("<span>",{class:"text-nowrap"}).text("0 of "+this.packsUpdateDetails.toHandle+" language "+g.pluralize(this.packsUpdateDetails.toHandle)+" updated")))),i.empty(),o.forEach(t=>{l.forEach(a=>{this.getNotificationBox().empty(),new n(p.getUrl()).post({install:{action:"languagePacksUpdatePack",token:this.getModuleContent().data("language-packs-update-pack-token"),iso:t,extension:a}}).then(async t=>{const a=await t.resolve();!0===a.success?(this.packsUpdateDetails.handled++,"new"===a.packResult?this.packsUpdateDetails.new++:"update"===a.packResult?this.packsUpdateDetails.updated++:this.packsUpdateDetails.failed++,this.packUpdateDone(d,o)):(this.packsUpdateDetails.handled++,this.packsUpdateDetails.failed++,this.packUpdateDone(d,o))},()=>{this.packsUpdateDetails.handled++,this.packsUpdateDetails.failed++,this.packUpdateDone(d,o)})})})}packUpdateDone(t,a){const e=this.getModalBody(),s=this.findInModal(this.selectorOutputContainer);if(this.packsUpdateDetails.handled===this.packsUpdateDetails.toHandle){const s=d.render(c.ok,"Language packs updated",this.packsUpdateDetails.new+" new language "+g.pluralize(this.packsUpdateDetails.new)+" downloaded, "+this.packsUpdateDetails.updated+" language "+g.pluralize(this.packsUpdateDetails.updated)+" updated, "+this.packsUpdateDetails.failed+" language "+g.pluralize(this.packsUpdateDetails.failed)+" not available");this.addNotification(s),!0===t?new n(p.getUrl()).post({install:{action:"languagePacksUpdateIsoTimes",token:this.getModuleContent().data("language-packs-update-iso-times-token"),isos:a}}).then(async t=>{if(!0===(await t.resolve()).success)this.getData();else{const t=o.render(c.error,"Something went wrong","");this.addNotification(t)}},t=>{p.handleAjaxError(t,e)}):this.getData()}else{const t=this.packsUpdateDetails.handled/this.packsUpdateDetails.toHandle*100;s.find(".progress-bar").css("width",t+"%").attr("aria-valuenow",t).find("span").text(this.packsUpdateDetails.handled+" of "+this.packsUpdateDetails.toHandle+" language "+g.pluralize(this.packsUpdateDetails.handled,"pack","s",this.packsUpdateDetails.toHandle)+" updated")}}languageMatrixHtml(t){const a=this.findInModal(this.selectorActivateLanguageIcon).html(),s=this.findInModal(this.selectorDeactivateLanguageIcon).html(),n=this.findInModal(this.selectorLanguageUpdateIcon).html(),i=e("<div>"),o=e("<tbody>");return t.languages.forEach(t=>{const i=t.active,d=e("<tr>");i?o.append(d.append(e("<td>").text(" "+t.name).prepend(e("<div />",{class:"btn-group"}).append(e("<a>",{class:"btn btn-default t3js-languagePacks-deactivateLanguage","data-iso":t.iso,"data-toggle":"tooltip",title:"Deactivate"}).append(s),e("<a>",{class:"btn btn-default t3js-languagePacks-update","data-iso":t.iso,"data-toggle":"tooltip",title:"Download language packs"}).append(n))))):o.append(d.addClass("t3-languagePacks-inactive t3js-languagePacks-inactive").css({display:"none"}).append(e("<td>").text(" "+t.name).prepend(e("<div />",{class:"btn-group"}).append(e("<a>",{class:"btn btn-default t3js-languagePacks-activateLanguage","data-iso":t.iso,"data-toggle":"tooltip",title:"Activate"}).append(a))))),d.append(e("<td>").text(t.iso),e("<td>").text(t.dependencies.join(", ")),e("<td>").text(null===t.lastUpdate?"":t.lastUpdate)),o.append(d)}),i.append(e("<h3>").text("Active languages"),e("<table>",{class:"table table-striped table-bordered"}).append(e("<thead>").append(e("<tr>").append(e("<th>").append(e("<div />",{class:"btn-group"}).append(e("<button>",{class:"btn btn-default t3js-languagePacks-addLanguage-toggle",type:"button"}).append(e("<span>").append(a)," Add language"),e("<button>",{class:"btn btn-default disabled update-all t3js-languagePacks-update",type:"button",disabled:"disabled"}).append(e("<span>").append(n)," Update all"))),e("<th>").text("Locale"),e("<th>").text("Dependencies"),e("<th>").text("Last update"))),o)),Array.isArray(this.activeLanguages)&&this.activeLanguages.length&&i.find(".update-all").removeClass("disabled").removeAttr("disabled"),i.html()}extensionMatrixHtml(t){const a=new i,s=this.findInModal(this.selectorExtensionPackMissesIcon).html(),n=this.findInModal(this.selectorLanguageUpdateIcon).html();let o,l="",p=!0,g=0;const r=e("<div>"),h=e("<tr>");h.append(e("<th>").text("Extension"),e("<th>").text("Key")),t.activeLanguages.forEach(t=>{h.append(e("<th>").append(e("<a>",{class:"btn btn-default t3js-languagePacks-update","data-iso":t,"data-toggle":"tooltip",title:"Download and update all language packs"}).append(e("<span>").append(n)," "+t)))});const u=e("<tbody>");return t.extensions.forEach(t=>{if(p=!0,t.packs.forEach(t=>{!1===t.exists&&(p=!1)}),!0===p)return;g++,o=""!==t.icon?e("<span>").append(e("<img>",{style:"max-height: 16px; max-width: 16px;",src:"../"+t.icon,alt:t.title}),e("<span>").text(" "+t.title)):e("<span>").text(t.title);const n=e("<tr>");n.append(e("<td>").html(o.html()),e("<td>").text(t.key)),t.packs.forEach(i=>{const o=e("<td>");n.append(o),!0!==i.exists&&(l=null!==i.lastUpdate?"No language pack available for "+i.iso+" when tried at "+i.lastUpdate+". Click to re-try.":"Language pack not downloaded. Click to download",o.append(e("<a>",{class:"btn btn-default t3js-languagePacks-update","data-extension":t.key,"data-iso":i.iso,"data-toggle":"tooltip",title:a.encodeHtml(l)}).append(s)))}),u.append(n)}),r.append(e("<h3>").text("Translation status"),e("<table>",{class:"table table-striped table-bordered"}).append(e("<thead>").append(h),u)),0===g?d.render(c.ok,"Language packs have been found for every installed extension.","To download the latest changes, use the refresh button in the list above."):r.html()}getNotificationBox(){return this.findInModal(this.selectorNotifications)}addNotification(t){this.notifications.push(t)}renderNotifications(){const t=this.getNotificationBox();for(let a of this.notifications)t.append(a);this.notifications=[]}}return new g}));