<?php

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

namespace TYPO3\CMS\Frontend\Http;

use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;

/**
 * This interface needs to be implemented by all classes that register for the hook in:
 * $GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['urlProcessing']['urlProcessors']
 *
 * It can be used manipulate URLs that are generated by the ContentObjectRenderer.
 */
interface UrlProcessorInterface
{
    const CONTEXT_COMMON = 'common';
    const CONTEXT_FILE = 'file';
    const CONTEXT_MAIL = 'mail';
    const CONTEXT_EXTERNAL = 'external';

    /**
     * Generates the JumpURL for the given parameters.
     *
     * @see \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer::processUrl()
     * @param string $context The context in which the URL is generated (e.g. "typolink" or one of the constants above).
     * @param string $url The URL that should be processed.
     * @param array $configuration The link configuration.
     * @param \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer $contentObjectRenderer The calling content object renderer.
     * @param bool $keepProcessing If this is set to FALSE no further hooks will be processed after the current one.
     * @return string|null
     */
    public function process($context, $url, array $configuration, ContentObjectRenderer $contentObjectRenderer, &$keepProcessing);
}
