<?php
namespace TYPO3\CMS\Install\Report;

/**
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

/**
 * Provides an environment status report
 *
 * @author Christian Kuhn <lolli@schwarzbu.ch>
 */
class EnvironmentStatusReport implements \TYPO3\CMS\Reports\StatusProviderInterface {

	/**
	 * Compile environment status report
	 *
	 * @throws \TYPO3\CMS\Install\Exception
	 * @return array<\TYPO3\CMS\Reports\Status>
	 */
	public function getStatus() {
		/** @var $statusCheck \TYPO3\CMS\Install\SystemEnvironment\Check */
		$statusCheck = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Install\\SystemEnvironment\\Check');
		$statusObjects = $statusCheck->getStatus();

		$reportStatusTypes = array(
			'error' => array(),
			'warning' => array(),
			'ok' => array(),
			'information' => array(),
			'notice' => array(),
		);

		/** @var $statusObject \TYPO3\CMS\Install\Status\AbstractStatus */
		foreach ($statusObjects as $statusObject) {
			$severityIdentifier = $statusObject->getSeverity();
			if (empty($severityIdentifier) || !is_array($reportStatusTypes[$severityIdentifier])) {
				throw new \TYPO3\CMS\Install\Exception('Unknown reports severity type', 1362602560);
			}
			$reportStatusTypes[$severityIdentifier][] = $statusObject;
		}

		$statusArray = array();
		foreach ($reportStatusTypes as $type => $statusObjects) {
			$value = count($statusObjects);
			if ($value > 0) {
				$pathToXliff = 'LLL:EXT:install/Resources/Private/Language/Report/locallang.xlf';
				// Map information type to abbreviation which is used in \TYPO3\CMS\Reports\Status class
				if ($type === 'information') {
					$type = 'info';
				}
				$message = $GLOBALS['LANG']->sL($pathToXliff . ':environment.status.message.' . $type);
				$severity = constant('\TYPO3\CMS\Reports\Status::' . strtoupper($type));
				$statusArray[] = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(
					'TYPO3\\CMS\\Reports\\Status',
					$GLOBALS['LANG']->sL($pathToXliff . ':environment.status.title'),
					sprintf($GLOBALS['LANG']->sL($pathToXliff . ':environment.status.value'), $value),
					$message,
					$severity
				);
			}
		}

		return $statusArray;
	}
}
