/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;

class MenuButton
extends Canvas {
    private static final long serialVersionUID = 1585446351088778635L;
    private PopupMenu _popup;
    private int _state = 0;
    private Applet _applet = null;
    private String _text = "My Button";
    private Font _font;
    Image imageBackground;
    Image offscreen;
    Graphics buffG;

    public MenuButton(Applet applet, PopupMenu popup, String text) {
        URL codeBase = applet.getCodeBase();
        String SERVER_NAME = codeBase.getHost();
        int port = applet.getDocumentBase().getPort();
        String protocol = applet.getDocumentBase().getProtocol();
        try {
            URL backgroundURL = new URL(protocol, SERVER_NAME, port, "/webEdition/images/java_menu/background.gif");
            this.imageBackground = applet.getImage(backgroundURL, "background.gif");
        }
        catch (MalformedURLException ex) {
            System.err.println(ex);
        }
        try {
            this._text = text;
            this._font = new Font("verdana", 1, 12);
            this._popup = popup;
            this._applet = applet;
            this.addMouseListener(new Clicked());
            RefreshThread refresht = new RefreshThread(this);
            refresht.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setState(int state) {
        this._state = state;
    }

    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        this.offscreen = this.createImage(dim.width, dim.height);
        this.buffG = this.offscreen.getGraphics();
        this.buffG.drawImage(this.imageBackground, 0, 0, this);
        Rectangle r = g.getClipBounds();
        if (this._state == 1) {
            this.paintThinBorder(this.buffG, r.x + 1, r.y + 1, r.width - 2, r.height - 2, true);
        } else if (this._state == 2) {
            this.paintThinBorder(this.buffG, r.x + 1, r.y + 1, r.width - 2, r.height - 2, false);
        }
        this.buffG.setFont(this._font);
        this.buffG.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        int x = 10;
        int y = r.height - (r.height - (fm.getHeight() - 5)) / 2;
        this.buffG.drawString(this._text, x + (this._state == 2 ? 1 : 0), y + (this._state == 2 ? 1 : 0));
        g.drawImage(this.offscreen, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void paintThinBorder(Graphics g, int x, int y, int w, int h, boolean raised) {
        this.paint3dRect(g, x, y, w, h, Color.white, Color.gray, raised);
    }

    private void paint3dRect(Graphics g, int x, int y, int w, int h, Color C1, Color C2, boolean raised) {
        if (!raised) {
            Color Tmp = C1;
            C1 = C2;
            C2 = Tmp;
        }
        g.setColor(C1);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + h);
        g.setColor(C2);
        g.drawLine(x + w, y, x + w, y + h + 1);
        g.drawLine(x, y + h, x + w, y + h);
    }

    private void clearRect(Graphics g, int x, int y, int w, int h, Color C1) {
        g.setColor(C1);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + h);
        g.drawLine(x + w, y, x + w, y + h + 1);
        g.drawLine(x, y + h, x + w, y + h);
    }

    public void showMenu() {
        Rectangle r = this.getBounds();
        if (this._state == 1) {
            this._popup.show(this, 0, r.height);
        }
    }

    class Clicked
    extends MouseAdapter {
        Clicked() {
        }

        public void mousePressed(MouseEvent e) {
            MenuButton.this.showMenu();
        }

        public void mouseEntered(MouseEvent e) {
            MenuButton.this._state = 1;
            MenuButton.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            MenuButton.this._state = 0;
            MenuButton.this.repaint();
        }
    }
}

