/*
 * Decompiled with CFR 0.152.
 */
import com.livinge.eplugin.editor.DocumentManager;
import com.livinge.eplugin.editor.EPDocument;
import com.livinge.eplugin.editor.WeEditor;
import com.livinge.eplugin.editor.WeSettings;
import com.livinge.eplugin.gui.EPEditorDialog;
import com.livinge.eplugin.privileged.PrivilegedSave;
import com.livinge.eplugin.util.Base64Coder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class EPlugin
extends JApplet {
    static final long serialVersionUID = -1611200117062004017L;
    static final String look = "System";
    protected EPEditorDialog editorDialog;
    protected WeSettings weSettings;
    protected String startDialog = "";
    protected String cmdEntry = "";
    private UIMonitor monUI = new UIMonitor();
    private CacheMonitor monCache = new CacheMonitor();
    protected boolean runThreads = true;
    protected final int threadTick = 500;
    protected boolean debug = true;
    protected Vector Messages = new Vector();
    private static final int MODE_INACTIVE = 0;
    private static final int MODE_EDITOR = 1;
    private static final int MODE_SETTINGS = 2;
    protected int runDialog = 0;
    public boolean isLive = true;

    private void initLookAndFeel() {
        String lookAndFeel = null;
        if (look != null) {
            lookAndFeel = look.equals("Metal") ? UIManager.getCrossPlatformLookAndFeelClassName() : (look.equals(look) ? UIManager.getSystemLookAndFeelClassName() : (look.equals("Motif") ? "com.sun.java.swing.plaf.motif.MotifLookAndFeel" : (look.equals("GTK+") ? "com.sun.java.swing.plaf.gtk.GTKLookAndFeel" : UIManager.getCrossPlatformLookAndFeelClassName())));
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                JFrame.setDefaultLookAndFeelDecorated(false);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void init() {
        URL codeBase = this.getCodeBase();
        String SERVER_NAME = codeBase.getHost();
        int port = this.getDocumentBase().getPort();
        String protocol = this.getDocumentBase().getProtocol();
        String url = port != -1 ? protocol + "://" + SERVER_NAME + ":" + port + "/webEdition/eplugin/initPlugin.html" : protocol + "://" + SERVER_NAME + "/webEdition/eplugin/initPlugin.html";
        try {
            this.getAppletContext().showDocument(new URL(url), "load");
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        this.initLookAndFeel();
        this.weSettings = new WeSettings();
        try {
            String[] plist = this.getParameter("param_list").split(",");
            for (int i = 0; i < plist.length; ++i) {
                this.weSettings.setParam(plist[i], this.getParameter(plist[i]));
            }
            this.weSettings.setUrl(this.getParameter("host").toString());
            this.weSettings.createCache();
            this.cmdEntry = this.getParameter("cmdentry");
        }
        catch (NullPointerException e) {
            System.out.print(e);
        }
        this.Messages = new Vector();
        this.monUI.start();
    }

    public void start() {
    }

    public void stop() {
        this.runThreads = false;
        this.gotoBed(1000);
    }

    public String getAppletInfo() {
        return "Editor Plugin\nAuthor Slavko Tomcic";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"param_list", "string", "list of dinamicaly loadable parameters"}};
        return pinfo;
    }

    protected void saveDwFiles(EPDocument doc) {
        String content = "webEditionUrl = \"" + this.weSettings.getHost() + "/webEdition/rpc/rpc.php\";\n";
        content = content + "sessionId = \"" + doc.getSessionId() + "\";\n";
        String fn = this.weSettings.registryDir + "/installation.js";
        PrivilegedSave ps = new PrivilegedSave(fn, content);
        AccessController.doPrivileged(ps);
        String path = new String(doc.getCacheFilename());
        path = EPlugin.replace(path, "\\", "\\\\");
        content = "transactions = new Object();\n";
        content = content + "transactions[\"" + path + "\"] = \"" + doc.getTransaction() + "\";\n";
        fn = this.weSettings.registryDir + "/transaction.js";
        ps = new PrivilegedSave(fn, content);
        AccessController.doPrivileged(ps);
    }

    protected void deleteDwFiles() {
        String fn = this.weSettings.registryDir + "/installation.js";
        try {
            new File(fn).delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        fn = this.weSettings.registryDir + "/transaction.js";
        try {
            new File(fn).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String clearPath(String in) {
        String out = "";
        out = in.replace('\\', '/');
        out = out.replaceAll("[/]+", "/");
        if (System.getProperty("os.name").matches("Windows(.)*")) {
            out = out.replace('/', '\\');
        }
        return out;
    }

    public void editSource(String sess, String trans, String filename, String code, String contenttype, String encoded, String charset) {
        this.weSettings.lastContentType = contenttype;
        String cachefn = "";
        cachefn = contenttype.equals("text/weTmpl") ? this.clearPath(this.weSettings.cacheDir + "template" + System.getProperty("file.separator") + filename) : this.clearPath(this.weSettings.cacheDir + "document" + System.getProperty("file.separator") + filename);
        System.out.println("contenttype:" + contenttype);
        EPDocument document = new EPDocument(sess, trans, cachefn, contenttype, this.cmdEntry);
        if (encoded.equals("true")) {
            code = Base64Coder.decode(code, charset);
        }
        document.setSource(code);
        this.saveDwFiles(document);
        this.invokeEditor(document);
    }

    public void editFile(String sess, String trans, String path, String url, String contenttype) {
        String cachefn = "";
        cachefn = contenttype.equals("text/weTmpl") ? this.clearPath(this.weSettings.cacheDir + "template" + System.getProperty("file.separator") + path) : this.clearPath(this.weSettings.cacheDir + "document" + System.getProperty("file.separator") + path);
        EPDocument document = new EPDocument(sess, trans, cachefn, contenttype, this.cmdEntry);
        document.copyFromUrl(url);
        this.invokeEditor(document);
    }

    private void invokeEditor(EPDocument doc) {
        this.runDialog = 1;
        DocumentManager.addDocument(doc);
        if (!this.monUI.isAlive()) {
            this.monUI = new UIMonitor();
            this.monUI.start();
        }
        this.runThreads = true;
        if (!this.monCache.isAlive()) {
            this.monCache.start();
        }
    }

    public void editSettings() {
        this.runDialog = 2;
        if (!this.monUI.isAlive()) {
            this.monUI = new UIMonitor();
            this.monUI.start();
        }
    }

    public void removeDocument(String transaction) {
        DocumentManager.removeDocument(transaction);
    }

    public boolean inEditor(String transaction) {
        return DocumentManager.hasDocument(transaction);
    }

    public int getDocumentCount() {
        return DocumentManager.getCount();
    }

    private void gotoBed(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void setSource(String sourceCode) {
        DocumentManager.getCurrent().setSource(sourceCode);
    }

    public String getSource(String trans) {
        return DocumentManager.getDocument(trans).getSource();
    }

    public void addMessage(String message) {
        this.Messages.add(message);
    }

    public boolean hasMessages() {
        return !this.Messages.isEmpty();
    }

    public String getMessages() {
        String mess = "";
        Iterator i = this.Messages.iterator();
        while (i.hasNext()) {
            mess = mess + "\n" + i.next().toString();
        }
        this.Messages.removeAllElements();
        return mess;
    }

    public void destroy() {
        this.deleteDwFiles();
    }

    public static String replace(String source, String find, String replace) {
        if (source != null) {
            int len = find.length();
            StringBuffer buff = new StringBuffer();
            int found = -1;
            int start = 0;
            while ((found = source.indexOf(find, start)) != -1) {
                buff.append(source.substring(start, found));
                buff.append(replace);
                start = found + len;
            }
            buff.append(source.substring(start));
            return buff.toString();
        }
        return "";
    }

    public int getDocCount() {
        return DocumentManager.getCount();
    }

    class CacheMonitor
    extends Thread {
        CacheMonitor() {
        }

        public void run() {
            while (EPlugin.this.runThreads) {
                DocumentManager.reset();
                while (DocumentManager.hasNext()) {
                    EPDocument doc = DocumentManager.next();
                    if (doc.getCacheFilename().equals("") || !doc.isChanged() || !doc.getCheck()) continue;
                    doc.setNewLastSave();
                    if (doc.isText()) {
                        doc.loadSource();
                        EPlugin.this.addMessage("setSource(\"" + doc.getTransaction() + "\");");
                        continue;
                    }
                    doc.uploadFile();
                    EPlugin.this.addMessage("reloadContentFrame(\"" + doc.getTransaction() + "\");");
                }
                EPlugin.this.gotoBed(500);
            }
        }
    }

    class UIMonitor
    extends Thread {
        UIMonitor() {
        }

        public void run() {
            while (EPlugin.this.runThreads) {
                if (EPlugin.this.runDialog == 1) {
                    EPDocument doc = DocumentManager.getLast();
                    if (EPlugin.this.weSettings.getSetting("askForEditor").equals("true")) {
                        EPlugin.this.editorDialog = new EPEditorDialog(doc, EPlugin.this.weSettings, 1);
                        EPlugin.this.editorDialog.pack();
                        EPlugin.this.editorDialog.setVisible(true);
                    } else {
                        EPlugin.this.weSettings.loadEditorList(doc.getCacheFilename(), doc.getContentType());
                        WeEditor ed = EPlugin.this.weSettings.getDefaultEditor(doc.getContentType());
                        if (ed != null) {
                            ed.start(doc);
                        } else {
                            JOptionPane.showMessageDialog(EPlugin.this.editorDialog, EPlugin.this.weSettings.getParam("lan_alert_nodefeditor_text"), EPlugin.this.weSettings.getParam("lan_alert_noeditor_title"), 0);
                        }
                    }
                } else if (EPlugin.this.runDialog == 2) {
                    EPlugin.this.editorDialog = new EPEditorDialog(new EPDocument(), EPlugin.this.weSettings, 2);
                    EPlugin.this.editorDialog.pack();
                    EPlugin.this.editorDialog.setVisible(true);
                }
                EPlugin.this.runDialog = 0;
                EPlugin.this.gotoBed(500);
            }
        }

        protected void log(String s) {
            if (EPlugin.this.debug) {
                System.out.println(s);
            }
        }
    }
}

