<?php

/**
 * webEdition CMS
 *
 * This source is part of webEdition CMS. webEdition CMS is
 * free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * The GNU General Public License can be found at
 * http://www.gnu.org/copyleft/gpl.html.
 * A copy is found in the textfile
 * webEdition/licenses/webEditionCMS/License.txt
 *
 * @category   webEdition
 * @package    webEdition_language
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL
 */


//
// ---> Template
//

$lang["Template"]["headline"] = "First Steps Wizard";
$lang["Template"]["title"] = "First Steps Wizard";
$lang["Template"]["autocontinue"] = "Sie werden automatisch in %s Sekunden weitergeleitet.";


//
// ---> Buttons
//

$lang["Buttons"]["next"] = "weiter";
$lang["Buttons"]["back"] = "zurck";


//
// ---> Wizards
//
//

$lang["Wizard"]["MasterWizard"]["title"] = "";


//
// ---> Steps
//

// Startscreen
$lang["Step"]["Startscreen"]["title"] = "Willkommen";
$lang["Step"]["Startscreen"]["headline"] = "Willkommen";
$lang["Step"]["Startscreen"]["content"] = "Herzlich Willkommen zum webEdition First Steps Wizard (FSW). Dieser Einrichtungsassistent richtet sich in erster Linie an neue webEdition Benutzer, die ohne langes Handbuchstudium zu einem ersten Grundgerst fr Ihre Website gelangen mchten. Aber auch fr webEdition Experten bietet der Wizard die Mglichkeit, mit wenigen Mausklicks eine funktionierende webEdition Prsenz zu erstellen, die dann individuell angepasst werden kann.<br /><br />Auf den folgenden Seiten untersttzt Sie der FSW bei der Installation eines ersten Layouts fr Ihre Website. Im rechten Drittel des Wizards finden Sie hilfreiche Hinweise und Erklrungen zu den jeweiligen Schritten.<br /><br />Nach der Installation des Layouts knnen Sie den Funktionsumfang Ihrer Seite durch weitere Funktionen, wie z.B Gstebuch oder Bildergalerie erweitern. Auch hierbei unterstztzt Sie der FSW: ber Datei > Neu > webEdition-Seite > Sonstige erreichen Sie den FSW, der Sie bei der Installation weiterer Funktionen untersttzt.<br /><br />Sie vermissen die webEdition Demoseiten? Kein Problem: laden Sie die webEdition Demos als Backup unter <a href=\"http://demo.webedition.org/\" target=\"_blank\" class=\"defaultfont\">http://demo.webedition.org</a> kostenlos von unserer Website. Der Import erfolgt ber Datei > Backup > Backup wiederherstellen...";
$lang["Step"]["Startscreen"]["description"] = "Der webEdition <b>First Steps Wizard (FSW)</b> untersttzt Sie bei Ihren ersten Schritten mit dem <b>Web Content Management System (WCMS)</b> webEdition.<br /><br />webEdition installiert in der Version 5 keine Beispieldateien mehr. Dadurch haben Sie ein sofort einsatzfhiges System zur Verfgung.<br /><br />Die Anzahl der Layouts fr den FSW wird weiterwachsen. berprfen Sie von Zeit zu Zeit, ob neue Layouts vorhanden sind. Dazu mssen Sie nur den FSW ausfhren.<br /><br />Sie knnen den First Steps Wizard jederzeit ber Datei > Neu > Wizards > First Steps Wizard aufrufen.<br /><br />Mit den Buttons Weiter und Zurck knnen Sie innerhalb des Wizards eine Seite nach vorne oder hinten springen.";

$lang["Step"]["Startscreen"]["no_connection"] = "Es konnte keine Verbindung zum Vorlagenserver aufgebaut werden.";
$lang["Step"]["Startscreen"]["error"] = "Fehler";


// ChooseDesign
$lang["Step"]["ChooseDesign"]["title"] = "Layout whlen";
$lang["Step"]["ChooseDesign"]["headline"] = "Layout whlen";
$lang["Step"]["ChooseDesign"]["content"] = "";
$lang["Step"]["ChooseDesign"]["description"] = "Bitte whlen Sie hier eines der derzeit zur Verfgung stehenden Layouts aus.<br /><br />Die dargestellten Layouts knnen kostenfrei verwendet und nach Ihren Bedrfnissen angepasst werden.<br /><br />Sie knnen diesen Vorgang jederzeit wiederholen und so auf einfache Weise das Layout Ihrer Webseite ndern.<br /><br />Klicken Sie auf Vorschau, um sich ein Design vergrert anzeigen zu lassen.<br /><br />Das webEdition Team wird auch in Zukunft weitere Designs verffentlichen. Rufen Sie einfach den First Steps Wizard erneut auf und lassen Sie sich berraschen.<br /><br />Bei der Installation wird eine sogenannte <b>Hauptvorlage (Mastertemplate)</b> installiert, auf der das Aussehen aller Seiten basiert.<br /><br />Mit webEdition knnen Sie barrierefreie Webseiten ertstellen, die auch von Screenreadern und auf Handhelds gelesen werden knnen.";

$lang["Step"]["ChooseDesign"]["no_import"] = "Sie haben kein Layout ausgewhlt.";


// DetermineFiles
$lang["Step"]["DetermineFiles"]["title"] = "Bentigte Dateien herunterladen";
$lang["Step"]["DetermineFiles"]["headline"] = "Bentigte Dateien herunterladen";
$lang["Step"]["DetermineFiles"]["content"] = "Die Dateien fr das von Ihnen ausgewhlte Layout werden nun von unserem Server auf Ihren Server bertragen und in webEdition importiert. Es handelt sich dabei um die Hauptvorlage (Mastertemplate), eine Vorlage fr Textseiten, CSS-Stile und layoutspezifische Dateien, wie z. B. Bilder und Grafiken.<br /><br />Die heruntergeladenen Dateien werden nach dem erfolgreichen Import im webEdition Dateibaum angezeigt.<br /><br />Links neben dem Dateibaum befinden sich Karteireiter (Tabs), mit denen Sie zwischen Dokumenten und Vorlagen umschalten knnen. Dokumente und Vorlagen haben jeweils einen eigenen Dateibaum und enthalten unterschiedliche Dateien.<br /><br />Wenn Sie bereits ein Layout mit dem Wizard installiert haben, wird dieses durch das neue Layout berschrieben! Falls Sie das alte Layout bewahren wollen, mssen Sie die dazugehrigen Dateien in andere Ordner verschieben.<br /><br />Im webEdition Dokumentenverzeichnis werden folgende Verzeichnisse angelegt:<br />&nbsp;&nbsp;&nbsp;_include<br />&nbsp;&nbsp;&nbsp;_layout<br /><br />Im webEdition Vorlagenverzeichnis werden folgende Verzeichnisse angelegt:<br />&nbsp;&nbsp;&nbsp;include<br />&nbsp;&nbsp;&nbsp;master<br /><br />Um weitere Funktionen zu ergnzen, starten Sie bitte nach erfolgreichem Import des Layouts den FSW erneut mit Datei > Neu > webEdition-Seite > Sonstige";
$lang["Step"]["DetermineFiles"]["description"] = "Je nach Gre und Anzahl der Dateien und der Geschwindigkeit der Internetanbindung kann der Download einige Zeit in Anspruch nehmen.<br /><br />Das WCMS webEdition trennt strikt zwischen Inhalt und Design. So kann eine einheitliche Gestaltung der Website gewhrleistet werden.<br /><br />Die Layouts werden von unserem Server geladen; dabei werden keinerlei persnliche Daten erfasst oder gespeichert.<br /><br />Bearbeitbare Bereiche werden in webEdition mit sogenannten &lt;we:tags&gt; ausgezeichnet. Derzeit gibt es knapp 200 davon!<br /><br />Mit dem Editor PlugIn knnen Sie Ihre webEdition Vorlagen ganz einfach in Ihrem HTML-Editor bearbeiten.";

// DownloadFiles
$lang["Step"]["DownloadFiles"]["title"] = $lang["Step"]["DetermineFiles"]["title"];
$lang["Step"]["DownloadFiles"]["headline"] = $lang["Step"]["DetermineFiles"]["headline"];
$lang["Step"]["DownloadFiles"]["content"] = $lang["Step"]["DetermineFiles"]["content"];
$lang["Step"]["DownloadFiles"]["description"] = $lang["Step"]["DetermineFiles"]["description"];

// ImportOptions
$lang["Step"]["ImportOptions"]["title"] = $lang["Step"]["DetermineFiles"]["title"];
$lang["Step"]["ImportOptions"]["headline"] = $lang["Step"]["DetermineFiles"]["headline"];
$lang["Step"]["ImportOptions"]["content"] = $lang["Step"]["DetermineFiles"]["content"];
$lang["Step"]["ImportOptions"]["description"] = $lang["Step"]["DetermineFiles"]["description"];

// ImportFiles
$lang["Step"]["ImportFiles"]["title"] = "Bentigte Dateien vorbereiten";
$lang["Step"]["ImportFiles"]["headline"] = "Bentigte Dateien vorbereiten";
$lang["Step"]["ImportFiles"]["content"] = "Die Layout Dateien befinden sich nun auf Ihrem Server. In diesem Schritt werden Sie in webEdition importiert. Im Rahmen dieses Importes werden die Inhalte in die Datenbank eingetragen und die Verzeichnisse und Dateien in der webEdition Oberflche angelegt.<br /><br />Fr Ihre ersten Schritte mit webEdition wird ein einfaches Textdokument mitgeliefert. Hier knnen Sie in einem WYSIWYG-Textfeld (What you see is what you get) bereits erste Inhalte anlegen und mit Ihrer Webseite experimentieren.<br /><br />Legen Sie Ihre erste textbasierte Seite mit Datei > Neu > webEdition-Seite > Textseite an. Hier knnen Sie zum Beispiel bereits Ihre Gste begren oder Ihre Webseite kurz vorstellen.<br /><br />Eine zweistufige Navigation ist bereits angelegt. Passen Sie die Navigation fr Ihre neue Webseite mit dem Navigationstool an. Das Navigationstool erreichen Sie ber Extras > Naviagtion... Hier knnen Sie komfortabel neue Navigationseintrge erstellen oder bearbeiten.<br /><br />Bevor die nderungen an einer webEdition-Seite auf Ihrer Homepage angezeigt werden, mssen Sie es speichern und verffentlichen!<br /><br />Mit den neuen MultiTabs knnen Sie mehrere webEdition-Seiten und Vorlagen gleichzeitig geffnet haben. So knnen Sie schnell zwischen einem Dokument und dessen Vorlage hin und herschalten, um nderungen am Quellcode sofort nachvollziehen zu knnen.<br /><br />Dokumente und Vorlagen verfgen ber mehrere Karteireiter am oberen Rand, mit denen Sie zwischen verschiedenen Ansichten umschalten knnen. So lassen sich  Dokumente validieren oder weitere Informationen ber Vorlagen anzeigen.";
$lang["Step"]["ImportFiles"]["description"] = "Kennen Sie den seeMode? In dieser vereinfachten Darstellung navigieren Sie in webEdition wie auf der fertigen Webseite. Aktivieren Sie einfach den seeMode Radiobutton beim Login.<br /><br />Importierte Bilder knnen Sie direkt in webEdition beschneiden oder skalieren. Whlen Sie einfach die Datei in der Ansicht Bearbeiten aus.<br /><br />Das neue Editor PlugIn kann Dateiformate, wie z. B. .doc oder .jpg, direkt mit der Ausgangsapplikation verknpfen: Editor starten, Datei bearbeiten, speichern -fertig!<br /><br />Sie finden nicht das richtige we:tag? In der Bearbeiten Ansicht von Vorlagen finden Sie den Tagwizard: dort sind alle Tags mit einer kurzen Erklrung aufgefhrt!";

// Finish
$lang["Step"]["Finish"]["title"] = "Layout wurde angelegt";
$lang["Step"]["Finish"]["headline"] = "Das Layout wurde angelegt...";
$lang["Step"]["Finish"]["content"] = "Herzlichen Glckwunsch, das Layout wurde erfolgreich importiert!<br /><br />Bevor Sie loslegen, knnen Sie noch einen Rebuild durchfhren:";
$lang["Step"]["Finish"]["description"] = "In der Sidebar knnen beliebige webEdition-Seiten angezeigt werden: Ob Onlinehilfe oder eine bersicht aller Shopartikel - nutzen Sie die neuen Mglichkeiten.<br /><br />Sie knnen das webEdition Cockpit nach Ihren Vorstellungen anpassen: ber Cockpit > Widget hinzufgen knnen Sie weitere Widgets anzeigen lassen.<br /><br />Erstellen Sie regelmig  Backups Ihrer Webseite? Mit webEdition ist das ganz einfach: Datei > Backup > Backup erstellen...<br /><br />Was ist eigentlich ein <b>Rebuild</b>? webEdition erstellt Webseiten basierend auf Vorlagen. Sollten Sie die Vorlage einer statischen webEdition-Seite verndern, so mu diese neu \\\"gebaut\\\" und abgespeichert werden!";

$lang["Step"]["Finish"]["content_2"] = "Sollten Sie bereits frher ein Layout importiert haben, so mssen Sie auf jeden Fall einen Rebuild durchfhren!<br /><br />In der neuen Sidebar knnen Sie sich die weiteren Mglichkeiten fr Ihre neue Webseite anzeigen lassen. Sie gelangen dort direkt zu neuen Textdokumenten oder weiteren Funktionen, die Sie fr die Seite nachinstallieren knnen!<br /><br />Wir wnschen Ihnen mit dem WCMS webEdition viel Spa. Wenn Sie immer ber die neuesten Entwicklungen informiert werden mchten, abonnieren Sie doch unseren Newsletter unter <a href=\"http://www.webedition.de/de/newsletter/\" target=\"_blank\" class=\"defaultfont\">http://www.webedition.de/de/newsletter</a><br /><br />Bei Fragen wenden Sie sich bitte an unseren Support unter <a href=\"http://support.webedition.de/de/webedition/\" target=\"_blank\" class=\"defaultfont\">http://support.webedition.de/de/webedition</a>";

?>