<?php
/**
 * ionCube Loader install Wizard
 *
 * ionCube is a registered trademark of ionCube Ltd.
 *
 * Copyright (c) ionCube Ltd. 2002-2011
 */


define ('LOADER_VERSION_URL','http://www.ioncube.com/feeds/product_info/versions.php');
define ('LOADER_PLATFORM_URL',LOADER_VERSION_URL . '?item=loader-platforms');
//define ('LOADER_PLATFORM_URL','http://addons.xt-commerce.com/webservices/ioncube.php');
define ('LOADERS_PAGE','http://loaders.ioncube.com/');
define ('IONCUBE_DOWNLOADS_SERVER','http://downloads2.ioncube.com/loader_downloads');
define ('IONCUBE_CONNECT_TIMEOUT',4);
define ('PHP_COMPILERS_URL',LOADER_VERSION_URL . '?item=php-compilers');

function required_loader($unamestr = '')
{
    $un = empty($unamestr)?uname():$unamestr;

    $php_major_version = substr(PHP_VERSION,0,3);

    $os_name = substr($un,0,strpos($un,' '));
    $os_code = empty($os_name)?'':strtolower(substr($os_name,0,3));

    $wordsize = calc_word_size($os_code);

    $arch = required_loader_arch($un,$os_code,$wordsize);
    if (!is_string($arch)) {
        return $arch;
    }

    $os_variants = supported_os_variants($os_code,$arch);

    if (!is_array($os_variants)) {
        return $os_variants;
    }

    $os_ver = '';
    if (preg_match('/([0-9.]+)/',uname('r'),$match)) {
        $os_ver = $match[1];
    }
    $os_ver_parts = preg_split('@\.@',$os_ver);

    $loader_sfix = (($os_code == 'win') ? 'dll' : 'so');
    $file = "ioncube_loader_${os_code}_${php_major_version}.${loader_sfix}";

    if ($os_code == 'win') {
        $os_name = 'Windows';
        $file_ts = $file;
        $os_name_qual = 'Windows';
    } else {
        $os_names = array_keys($os_variants);
        if (count($os_variants) > 1) {
            $parts = explode(" ",$os_names[0]);
            $os_name = $parts[0];
            $os_name_qual = $os_name . ' ' . $os_ver_parts[0] . '.' . $os_ver_parts[1];
        } else {
            $os_name = $os_names[0];
            $os_name_qual = $os_name;
        }
        $file_ts = "ioncube_loader_${os_code}_${php_major_version}_ts.${loader_sfix}";
    }

    return array(
        'uname'      =>  $un,
        'arch'       =>  $arch,
        'oscode'     =>  $os_code,
        'osname'     =>  $os_name,
        'osnamequal' =>  $os_name_qual,
        'osvariants' =>  $os_variants,
        'osver'      =>  $os_ver,
        'osver2'     =>  $os_ver_parts,
        'file'       =>  $file,
        'file_ts'    =>  $file_ts,
        'wordsize'   =>  $wordsize
    );
}

function uname($part = 'a')
{
    $result = '';
    if (!function_is_disabled('php_uname')) {
        $result = @php_uname($part);
    } elseif (function_exists('posix_uname') && !function_is_disabled('posix_uname')) {
        $posix_equivs = array(
            'm' => 'machine',
            'n' => 'nodename',
            'r' => 'release',
            's' => 'sysname'
        );
        $puname = @posix_uname();
        if ($part == 'a' || !array_key_exists($part,$posix_equivs)) {
            $result = join(' ',$puname);
        } else {
            $result = $puname[$posix_equivs[$part]];
        }
    } else {
        if (!function_is_disabled('phpinfo')) {
            ob_start();
            phpinfo(INFO_GENERAL);
            $pinfo = ob_get_contents();
            ob_end_clean();
            if (preg_match('~System.*?(</B></td><TD ALIGN="left">| => |v">)([^<]*)~i',$pinfo,$match)) {
                $uname = $match[2];
                if ($part == 'r') {
                    if (!empty($uname) && preg_match('/\S+\s+\S+\s+([0-9.]+)/',$uname,$matchver)) {
                        $result = $matchver[1];
                    } else {
                        $result = '';
                    }
                } else {
                    $result = $uname;
                }
            }
        } else {
            $result = '';
        }
    }
    return $result;
}

function function_is_disabled($fn_name)
{
    $disabled_functions=explode(',',ini_get('disable_functions'));
    return in_array($fn_name, $disabled_functions);
}

function calc_word_size($os_code)
{
    $wordsize = null;
    if ('win' === $os_code) {
        ob_start();
        phpinfo(INFO_GENERAL);
        $pinfo = ob_get_contents();
        ob_end_clean();
        if (preg_match('~Compiler.*?(</B></td><TD ALIGN="left">| => |v">)([^<]*)~i',$pinfo,$compmatch)) {
            if (preg_match("/(VC[0-9]+)/i",$compmatch[2],$vcmatch)) {
                $compiler = strtoupper($vcmatch[1]);
            } else {
                $compiler = 'VC6';
            }
        } else {
            $compiler = 'VC6';
        }
        if ($compiler === 'VC9') {
            if (isset($_ENV['PROCESSOR_ARCHITECTURE']) && preg_match('~(amd64|x86-64|x86_64)~i',$_ENV['PROCESSOR_ARCHITECTURE'])) {
                if (preg_match('~Configure Command.*?(</B></td><TD ALIGN="left">| => |v">)([^<]*)~i',$pinfo,$confmatch)) {
                    if (preg_match('~(x64|lib64|system64)~i',$confmatch[2])) {
                        $wordsize = 64;
                    }
                }
            }
        }
    }
    if (empty($wordsize)) {
        $wordsize = ((-1^0xffffffff)?64:32);
    }
    return $wordsize;
}

function required_loader_arch($mach_info,$os_code,$wordsize)
{
    if ($os_code == 'win') {
        $arch = ($wordsize == 32)?'x86':'x86-64';
        if ($wordsize != 32) {
            $arch = ERROR_WINDOWS_64_BIT;
        }
    } elseif (!empty($os_code)) {
        $arch = match_arch_pattern($mach_info);
        if ($wordsize == 64) {
            if ($arch == 'x86') {
                $arch = 'x86-64';
            } elseif ($arch == 'ppc') {
                $arch = 'ppc64';
            }
        }
    } else {
        $arch = ERROR_UNKNOWN_ARCH;
    }
    return $arch;
}

function match_arch_pattern($str)
{
    $arch = null;
    $arch_patterns = array(
        'i.?86'        => 'x86',
        'x86[-_]64'    => 'x86',
        'x86'          => 'x86',
        'amd64'        => 'x86',
        'ppc64'        => 'ppc',
        'ppc'          => 'ppc',
        'powerpc'      => 'ppc',
        'sparc'        => 'sparc',
        'sun'          => 'sparc'
    );

    foreach ($arch_patterns as $token => $a) {
        if (preg_match("/$token/i", $str)) {
            $arch = $a;
            break;
        }
    }
    return $arch;
}

function supported_os_variants($os_code,$arch_code)
{
    if (empty($os_code)) {
        return ERROR_UNKNOWN_OS;
    }
    if (empty($arch_code)) {
        return ERROR_UNKNOWN_ARCH;
    }

    $os_found = false;
    $arch_found = false;
    $os_arch_matches = array();

    $pinfo = get_platforminfo();

    foreach ($pinfo as $p) {
        if ($p['os'] == $os_code && $p['arch'] == $arch_code) {
            $os_arch_matches[$p['os_human']] = (isset($p['os_mod']))?(0 + str_replace('_','',$p['os_mod'])):'';
        }
        if ($p['os'] == $os_code) {
            $os_found = true;
        } elseif ($p['arch'] == $arch_code) {
            $arch_found = true;
        }
    }
    if (!empty($os_arch_matches)) {
        asort($os_arch_matches);
        return $os_arch_matches;
    } elseif (!$os_found) {
        return ERROR_UNSUPPORTED_OS;
    } elseif (!$arch_found) {
        return ERROR_UNSUPPORTED_ARCH;
    } else {
        return ERROR_UNSUPPORTED_ARCH_OS;
    }
}

function default_win_compilers()
{
    return array('VC6','VC9');
}

function supported_win_compilers()
{
    static $win_compilers;

    if (empty($win_compilers)) {
        $win_compilers = find_win_compilers();
    }
    return $win_compilers;
}

function get_platforminfo()
{
    static $platforminfo;

    if (empty($platforminfo)) {
        $platforminfo = get_loader_platforms();
    }
    return $platforminfo;
}

function get_loader_platforms()
{
    return get_remote_session_value('loader_platform_info',LOADER_PLATFORM_URL,'default_platform_list');
}

function get_remote_session_value($session_var,$remote_url,$default_function)
{
    if (!isset($_SESSION[$session_var])) {


          //  $serialised_res = remote_file_contents($remote_url);

            $serialised_res = 'a:23:{i:0;a:6:{s:2:"os";s:3:"win";s:8:"os_human";s:11:"Windows VC6";s:6:"os_mod";s:4:"_vc6";s:4:"arch";s:3:"x86";s:7:"dirname";s:5:"win32";s:7:"us1-dir";s:15:"windows_vc6/x86";}i:1;a:6:{s:2:"os";s:3:"win";s:8:"os_human";s:20:"Windows VC6 (Non-TS)";s:6:"os_mod";s:10:"_nonts_vc6";s:4:"arch";s:3:"x86";s:7:"dirname";s:11:"win32-nonts";s:7:"us1-dir";s:21:"windows_vc6/x86-nonts";}i:2;a:6:{s:2:"os";s:3:"win";s:8:"os_human";s:11:"Windows VC9";s:6:"os_mod";s:4:"_vc9";s:4:"arch";s:3:"x86";s:7:"dirname";s:9:"win32_vc9";s:7:"us1-dir";s:15:"windows_vc9/x86";}i:3;a:6:{s:2:"os";s:3:"win";s:8:"os_human";s:20:"Windows VC9 (Non-TS)";s:6:"os_mod";s:10:"_nonts_vc9";s:4:"arch";s:3:"x86";s:7:"dirname";s:15:"win32-nonts_vc9";s:7:"us1-dir";s:21:"windows_vc9/x86-nonts";}i:4;a:5:{s:2:"os";s:3:"lin";s:8:"os_human";s:5:"Linux";s:4:"arch";s:3:"x86";s:7:"dirname";s:21:"linux_i686-glibc2.3.4";s:7:"us1-dir";s:9:"linux/x86";}i:5;a:5:{s:2:"os";s:3:"lin";s:8:"os_human";s:5:"Linux";s:4:"arch";s:6:"x86-64";s:7:"dirname";s:23:"linux_x86_64-glibc2.3.4";s:7:"us1-dir";s:12:"linux/x86_64";}i:6;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 4";s:6:"os_mod";s:2:"_4";s:4:"arch";s:3:"x86";s:7:"dirname";s:16:"freebsd_i386-4.8";s:7:"us1-dir";s:10:"FreeBSD/v4";}i:7;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 6";s:6:"os_mod";s:2:"_6";s:4:"arch";s:3:"x86";s:7:"dirname";s:16:"freebsd_i386-6.2";s:7:"us1-dir";s:14:"FreeBSD/v6/x86";}i:8;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 6";s:6:"os_mod";s:2:"_6";s:4:"arch";s:6:"x86-64";s:7:"dirname";s:17:"freebsd_amd64-6.2";s:7:"us1-dir";s:16:"FreeBSD/v6/AMD64";}i:9;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 7";s:6:"os_mod";s:2:"_7";s:4:"arch";s:3:"x86";s:7:"dirname";s:16:"freebsd_i386-7.3";s:7:"us1-dir";s:14:"FreeBSD/v7/x86";}i:10;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 7";s:6:"os_mod";s:2:"_7";s:4:"arch";s:6:"x86-64";s:7:"dirname";s:17:"freebsd_amd64-7.3";s:7:"us1-dir";s:16:"FreeBSD/v7/AMD64";}i:11;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 8";s:6:"os_mod";s:2:"_8";s:4:"arch";s:3:"x86";s:7:"dirname";s:16:"freebsd_i386-8.0";s:7:"us1-dir";s:14:"FreeBSD/v8/x86";}i:12;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 8";s:6:"os_mod";s:2:"_8";s:4:"arch";s:6:"x86-64";s:7:"dirname";s:17:"freebsd_amd64-8.0";s:7:"us1-dir";s:16:"FreeBSD/v8/AMD64";}i:13;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 9";s:6:"os_mod";s:2:"_9";s:4:"arch";s:3:"x86";s:7:"dirname";s:16:"freebsd_i386-9.0";s:7:"us1-dir";s:14:"FreeBSD/v9/x86";}i:14;a:6:{s:2:"os";s:3:"fre";s:8:"os_human";s:9:"FreeBSD 9";s:6:"os_mod";s:2:"_9";s:4:"arch";s:6:"x86-64";s:7:"dirname";s:17:"freebsd_amd64-9.0";s:7:"us1-dir";s:16:"FreeBSD/v9/AMD64";}i:15;a:6:{s:2:"os";s:3:"ope";s:8:"os_human";s:11:"OpenBSD 4.5";s:6:"os_mod";s:4:"_4.5";s:4:"arch";s:3:"x86";s:7:"dirname";s:16:"openbsd_i386-4.5";s:7:"us1-dir";s:11:"OpenBSD/x86";}i:16;a:6:{s:2:"os";s:3:"ope";s:8:"os_human";s:11:"OpenBSD 4.6";s:6:"os_mod";s:4:"_4.6";s:4:"arch";s:3:"x86";s:7:"dirname";s:16:"openbsd_i386-4.6";s:7:"us1-dir";s:11:"OpenBSD/x86";}i:17;a:6:{s:2:"os";s:3:"ope";s:8:"os_human";s:11:"OpenBSD 4.7";s:6:"os_mod";s:4:"_4.7";s:4:"arch";s:6:"x86-64";s:7:"dirname";s:17:"openbsd_amd64-4.7";s:7:"us1-dir";s:14:"OpenBSD/x86_64";}i:18;a:5:{s:2:"os";s:3:"dar";s:8:"os_human";s:4:"OS X";s:4:"arch";s:3:"ppc";s:7:"dirname";s:15:"osx_powerpc-8.5";s:7:"us1-dir";s:7:"OSX/ppc";}i:19;a:5:{s:2:"os";s:3:"dar";s:8:"os_human";s:4:"OS X";s:4:"arch";s:3:"x86";s:7:"dirname";s:13:"osx_i386-8.11";s:7:"us1-dir";s:7:"OSX/x86";}i:20;a:5:{s:2:"os";s:3:"dar";s:8:"os_human";s:4:"OS X";s:4:"arch";s:6:"x86-64";s:7:"dirname";s:15:"osx_x86_64-10.2";s:7:"us1-dir";s:10:"OSX/x86_64";}i:21;a:5:{s:2:"os";s:3:"sun";s:8:"os_human";s:7:"Solaris";s:4:"arch";s:5:"sparc";s:7:"dirname";s:17:"solaris_sparc-5.9";s:7:"us1-dir";s:13:"Solaris/sparc";}i:22;a:5:{s:2:"os";s:3:"sun";s:8:"os_human";s:7:"Solaris";s:4:"arch";s:3:"x86";s:7:"dirname";s:17:"solaris_i386-5.10";s:7:"us1-dir";s:11:"Solaris/x86";}}';

        $unserialised_res = @unserialize($serialised_res);
        if (empty($unserialised_res)) {
            $unserialised_res = call_user_func($default_function);
        }
        if (false === $unserialised_res) {
            $unserialised_res = '';
        }
        $_SESSION[$session_var] = $unserialised_res;
    }
    return $_SESSION[$session_var];
}

function get_file_contents($file)
{
    if (function_exists('file_get_contents')) {
        $strs = @file_get_contents($file);
    } else {
        $lines = @file($file);
        $strs = join(' ',$lines);
    }
    return $strs;
}

function remote_file_contents($url)

{
    $remote_file_opening = ini_get('allow_url_fopen');
    $contents = false;
    if (isset($_SESSION['timing_out']) && $_SESSION['timing_out']) {
        return false;
    }
    @session_write_close();
    $timing_out = 0;
    if ($remote_file_opening) {
        $fh = @fopen($url,'rb');
        if ($fh) {
            stream_set_blocking($fh,0);
            stream_set_timeout($fh,IONCUBE_CONNECT_TIMEOUT);
            while (!feof($fh)) {
                $result = fgets($fh, 4096);
                $info = stream_get_meta_data($fh);
                $timing_out = $info['timed_out']?1:0;
                if ($timing_out) {
                    break;
                }
                if ($result !== false) {
                    $contents .= $result;
                } else {
                    break;
                }
            }
            fclose($fh);
        } else {
            $timing_out = 1;
        }
    } elseif (extension_loaded('curl')) {

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT,IONCUBE_CONNECT_TIMEOUT);
        $output = curl_exec($ch);
        $info = curl_getinfo($ch);
        $timing_out = ($info['http_code'] >= 400)?1:0;
        curl_close($ch);

        if (is_string($output)) {
            $contents = $output;
        }
    } else {
        $timing_out = 1;
    }
    @session_start();
    $_SESSION['timing_out'] = $timing_out;
    return $contents;
}

function default_platform_list()
{
    $platforms = array();


    $platforms[] = array('os'=>'win', 'os_human'=>'Windows VC6',        'os_mod' => '_vc6',     'arch'=>'x86',  'dirname'=>'win32', 'us1-dir'=>'windows_vc6/x86' );
    $platforms[] = array('os'=>'win', 'os_human'=>'Windows VC6 (Non-TS)',   'os_mod' => '_nonts_vc6',   'arch'=>'x86',  'dirname'=>'win32-nonts', 'us1-dir'=>'windows_vc6/x86-nonts' );

    $platforms[] = array('os'=>'win', 'os_human'=>'Windows VC9',        'os_mod' => '_vc9',     'arch'=>'x86',  'dirname'=>'win32_vc9', 'us1-dir'=>'windows_vc9/x86' );
    $platforms[] = array('os'=>'win', 'os_human'=>'Windows VC9 (Non-TS)',   'os_mod' => '_nonts_vc9',   'arch'=>'x86',  'dirname'=>'win32-nonts_vc9', 'us1-dir'=>'windows_vc9/x86-nonts' );

    $platforms[] = array('os'=>'lin', 'os_human'=>'Linux',              'arch'=>'x86',      'dirname'=>'linux_i686-glibc2.1.3', 'us1-dir'=>'linux/x86');
    $platforms[] = array('os'=>'lin', 'os_human'=>'Linux',              'arch'=>'x86-64',   'dirname'=>'linux_x86_64-glibc2.3.4', 'us1-dir'=>'linux/x86_64');
    $platforms[] = array('os'=>'lin','os_human'=>'Linux',               'arch'=>'ppc',      'dirname'=>'linux_ppc-glibc2.3.4','us1-dir'=>'linux/ppc');
    $platforms[] = array('os'=>'lin','os_human'=>'Linux',               'arch'=>'ppc64',    'dirname'=>'linux_ppc64-glibc2.5','us1-dir'=>'linux/ppc64');


    $platforms[] = array('os'=>'dra', 'os_human'=>'DragonFly',
        'arch'=>'x86',      'dirname'=>'dragonfly_i386-1.7', 'us1-dir'=>'Dragonfly/x86');

    $platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 4', 'os_mod'=>'_4',  'arch'=>'x86',      'dirname'=>'freebsd_i386-4.8', 'us1-dir'=>'FreeBSD/v4');

    $platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 6', 'os_mod'=>'_6',  'arch'=>'x86',      'dirname'=>'freebsd_i386-6.2', 'us1-dir'=>'FreeBSD/v6/x86');

    $platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 6', 'os_mod'=>'_6',  'arch'=>'x86-64',   'dirname'=>'freebsd_amd64-6.2', 'us1-dir'=>'FreeBSD/v6/AMD64');


    $platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 7', 'os_mod'=>'_7',  'arch'=>'x86',      'dirname'=>'freebsd_i386-7.3', 'us1-dir'=>'FreeBSD/v7/x86');
    $platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 7', 'os_mod'=>'_7',  'arch'=>'x86-64',   'dirname'=>'freebsd_amd64-7.3', 'us1-dir'=>'FreeBSD/v7/AMD64');


    $platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 8', 'os_mod'=>'_8',  'arch'=>'x86',      'dirname'=>'freebsd_i386-8.0', 'us1-dir'=>'FreeBSD/v8/x86');
    $platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 8', 'os_mod'=>'_8',  'arch'=>'x86-64',   'dirname'=>'freebsd_amd64-8.0', 'us1-dir'=>'FreeBSD/v8/AMD64');

    $platforms[] = array('os'=>'bsd', 'os_human'=>'BSDi',               'arch'=>'x86',      'dirname'=>'bsdi_i386-4.3.1');
    $platforms[] = array('os'=>'net', 'os_human'=>'NetBSD',             'arch'=>'x86',      'dirname'=>'netbsd_i386-2.1','us1-dir'=>'NetBSD/x86');
    $platforms[] = array('os'=>'net', 'os_human'=>'NetBSD',             'arch'=>'x86-64',   'dirname'=>'netbsd_amd64-2.0','us1-dir'=>'NetBSD/x86_64');
    $platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.2', 'os_mod'=>'_4.2',  'arch'=>'x86',  'dirname'=>'openbsd_i386-4.2', 'us1-dir'=>'OpenBSD/x86');

    $platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.5', 'os_mod'=>'_4.5',  'arch'=>'x86',  'dirname'=>'openbsd_i386-4.5', 'us1-dir'=>'OpenBSD/x86');
    $platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.6', 'os_mod'=>'_4.6',  'arch'=>'x86',  'dirname'=>'openbsd_i386-4.6', 'us1-dir'=>'OpenBSD/x86');

    $platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.7', 'os_mod'=>'_4.7',  'arch'=>'x86-64', 'dirname'=>'openbsd_amd64-4.7', 'us1-dir' => 'OpenBSD/x86_64');

    $platforms[] = array('os'=>'dar', 'os_human'=>'OS X',               'arch'=>'ppc',      'dirname'=>'osx_powerpc-8.5','us1-dir'=>'OSX/ppc');

    $platforms[] = array('os'=>'dar', 'os_human'=>'OS X',               'arch'=>'x86',      'dirname'=>'osx_i386-8.11','us1-dir'=>'OSX/x86');

    $platforms[] = array('os'=>'dar', 'os_human'=>'OS X',               'arch'=>'x86-64',       'dirname'=>'osx_x86-64-10.2','us1-dir'=>'OSX/x86_64');

    $platforms[] = array('os'=>'sun', 'os_human'=>'Solaris',            'arch'=>'sparc',    'dirname'=>'solaris_sparc-5.9', 'us1-dir'=>'Solaris/sparc');

    $platforms[] = array('os'=>'sun', 'os_human'=>'Solaris',            'arch'=>'x86',      'dirname'=>'solaris_i386-5.10','us1-dir'=>'Solaris/x86');

    return $platforms;
}

function zend_extension_lines($loader_dir)
{
    $zend_extension_lines = array();
    $sysinfo = get_sysinfo();
    $qt = (is_ms_windows()?'"':'');
    $loader = get_loaderinfo();

    if (!is_bool($sysinfo['THREAD_SAFE']) || !$sysinfo['THREAD_SAFE']) {
        $path = $qt . $loader_dir . DIRECTORY_SEPARATOR  . $loader['file'] . $qt;
        $zend_extension_lines[] = "zend_extension = " . $path;
    }
    if ((!is_bool($sysinfo['THREAD_SAFE']) && !is_php_version_or_greater(5,3)) || $sysinfo['THREAD_SAFE']) {
        $line_start = is_php_version_or_greater(5,3)?'zend_extension':'zend_extension_ts';
        $path = $qt . $loader_dir . DIRECTORY_SEPARATOR  . $loader['file_ts'] . $qt;
        $zend_extension_lines[] = $line_start . " = " . $path;
    }
    return $zend_extension_lines;
}

function is_php_version_or_greater($major,$minor,$release = 0)
{
    $version = php_version();
    return ($version['major'] > $major ||
        ($version['major'] == $major && $version['minor'] > $minor) ||
        ($version['major'] == $major && $version['minor'] == $minor && $version['release'] >= $release));
}

function php_version()
{
    $v = explode('.',PHP_VERSION);

    return array(
        'major'      =>  $v[0],
        'minor'      =>  $v[1],
        'release'    =>  $v[2]);
}

function get_sysinfo()
{
    static $sysinfo;

    if (empty($sysinfo)) {
        $sysinfo = ic_system_info();
    }
    return $sysinfo;
}
function ic_system_info()
{
    $thread_safe = null;
    $debug_build = null;
    $cgi_cli = false;
    $is_cgi = false;
    $is_cli = false;
    $php_ini_path = '';
    $php_ini_dir = '';
    $php_ini_add = '';
    $is_supported_compiler = true;
    $php_compiler = is_ms_windows()?'VC6':'';

    ob_start();
    phpinfo(INFO_GENERAL);
    $php_info = ob_get_contents();
    ob_end_clean();

    $breaker = (php_sapi_name() == 'cli')?'\n':'</tr>';
    $lines = explode($breaker,$php_info);
    foreach ($lines as $line) {
        if (preg_match('/command/i',$line)) {
            continue;
        }

        if (preg_match('/thread safety/i', $line)) {
            $thread_safe = (preg_match('/(enabled|yes)/i', $line) != 0);
        }

        if (preg_match('/debug build/i', $line)) {
            $debug_build = (preg_match('/(enabled|yes)/i', $line) != 0);
        }

        if (preg_match('~configuration file.*(</B></td><TD ALIGN="left">| => |v">)([^ <]*)~i',$line,$match)) {
            $php_ini_path = $match[2];

            if (!@file_exists($php_ini_path)) {
                $php_ini_path = '';
            }
        }
        if (preg_match('~dir for additional \.ini files.*(</B></td><TD ALIGN="left">| => |v">)([^ <]*)~i',$line,$match)) {
            $php_ini_dir = $match[2];
            if (!@file_exists($php_ini_dir)) {
                $php_ini_dir = '';
            }
        }
        if (preg_match('~additional \.ini files parsed.*(</B></td><TD ALIGN="left">| => |v">)([^ <]*)~i',$line,$match)) {
            $php_ini_add = $match[2];
        }
        if (preg_match('/compiler/i',$line)) {
            $supported_match = join('|',supported_win_compilers());
            $is_supported_compiler = preg_match("/($supported_match)/i",$line);
            if (preg_match("/(VC[0-9]+)/i",$line,$match)) {
                $php_compiler = strtoupper($match[1]);
            } else {
                $php_compiler = '';
            }
        }
    }
    $is_cgi = strpos(php_sapi_name(),'cgi') !== false;
    $is_cli = strpos(php_sapi_name(),'cli') !== false;
    $cgi_cli = $is_cgi || $is_cli;

    $ss = server_software_info();

    if (!$php_ini_path && function_exists('php_ini_loaded_file')) {
        $php_ini_path = php_ini_loaded_file();
        if ($php_ini_path === false) {
            $php_ini_path = '';
        }
    }
    if (!empty($php_ini_path)) {
        $real_path = @realpath($php_ini_path);
        if (false !== $real_path) {
            $php_ini_path = $real_path;
        }
    }

    $php_ini_basename = basename($php_ini_path);

    return array(
        'THREAD_SAFE'        => $thread_safe,
        'DEBUG_BUILD'        => $debug_build,
        'PHP_INI'            => $php_ini_path,
        'PHP_INI_BASENAME'   => $php_ini_basename,
        'PHP_INI_DIR'        => $php_ini_dir,
        'PHP_INI_ADDITIONAL' => $php_ini_add,
        'PHPRC'              => getenv('PHPRC'),
        'CGI_CLI'            => $cgi_cli,
        'IS_CGI'             => $is_cgi,
        'IS_CLI'             => $is_cli,
        'PHP_COMPILER'       => $php_compiler,
        'SUPPORTED_COMPILER' => $is_supported_compiler,
        'FULL_SS'            => $ss['full'],
        'SS'                 => $ss['short']);
}

function is_ms_windows()
{
    $loader_info = get_loaderinfo();
    return ($loader_info['oscode'] == 'win');
}

function get_loaderinfo()
{
    static $loader;

    if (empty($loader)) {
        $loader = required_loader();
    }
    return $loader;
}
function server_software_info()
{
    $ss = array('full' => '','short' => '');
    $ss['full'] = $_SERVER['SERVER_SOFTWARE'];

    if (preg_match('/apache/i', $ss['full'])) {
        $ss['short'] = 'Apache';
    } else if (preg_match('/IIS/',$ss['full'])) {
        $ss['short'] = 'IIS';
    } else {
        $ss['short'] = '';
    }
    return $ss;
}
function find_win_compilers()
{
    return get_remote_session_value('php_compilers_info',PHP_COMPILERS_URL,'default_win_compilers');
}
?>