<?php
//~ require_once 'vfsStream/vfsStream.php';
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc.inc');
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc_wrappers.inc');
require_once('../Klarna.php');

/**
 * Test class for KlarnaAddr.
 * Generated by PHPUnit on 2011-02-09 at 13:41:35.
 */
class KlarnaAddrTest extends PHPUnit_Framework_TestCase {

    /**
     * @var KlarnaAddr
     */
    protected $klarnaAddr;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->klarnaAddr = new KlarnaAddr("karl.lidin@klarna.com", "0765260000", "0765260000", "Karl", "Lidin", "careof", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE, "houseNo", "houseExt");
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        unset($this->klarnaAddr);
    }

    /**
     * @group allPHP
     */
    public function testEmail() {
        $this->assertEquals("karl.lidin@klarna.com", $this->klarnaAddr->getEmail());
        $this->klarnaAddr->setEmail("lidin.karl@klarna.com");
        $this->assertEquals("lidin.karl@klarna.com", $this->klarnaAddr->getEmail());
    }

    /**
     * @expectedException KlarnaException
     */
    public function testEmailException() {
        $this->assertNull($this->klarnaAddr->setEmail(null));
    }

    public function testTelno() {
        $this->assertEquals("0765260000", $this->klarnaAddr->getTelno());
        $this->klarnaAddr->setTelno(1234567890);
        $this->assertEquals("1234567890", $this->klarnaAddr->getTelno());
    }

    public function testCellno() {
        $this->assertEquals("0765260000", $this->klarnaAddr->getCellno());
        $this->klarnaAddr->setCellno(1234567890);
        $this->assertEquals("1234567890", $this->klarnaAddr->getCellno());
    }

    public function testFirstName() {
        $this->assertEquals("Karl", $this->klarnaAddr->getFirstName());
        $this->klarnaAddr->setFirstName(123);
        $this->assertEquals("123", $this->klarnaAddr->getFirstName());
    }

    /**
     * @expectedException KlarnaException
     */
    public function testFirstNameException() {
        $this->assertNull($this->klarnaAddr->setFirstName(""));
    }

    public function testLastName() {
        $this->assertEquals("Lidin", $this->klarnaAddr->getLastName());
        $this->klarnaAddr->setLastName(456);
        $this->assertEquals("456", $this->klarnaAddr->getLastName());
    }

    /**
     * @expectedException KlarnaException
     */
    public function testLastNameException() {
        $this->assertNull($this->klarnaAddr->setLastName(""));
    }

    public function testCompanyName() {
        $this->klarnaAddr->setCompanyName("Kalle Anka AB");
        $this->assertEquals("Kalle Anka AB", $this->klarnaAddr->getCompanyName());
    }

    /**
     * @expectedException KlarnaException
     */
    public function testCompanyNameException() {
        $this->assertNull($this->klarnaAddr->setCompanyName(null));
    }

    public function testCareof() {
        $this->assertEquals("careof", $this->klarnaAddr->getCareof());
        $this->klarnaAddr->setCareof(789);
        $this->assertEquals("789", $this->klarnaAddr->getCareof());
    }

    public function testStreet() {
        $this->assertEquals("Junibacksg 42", $this->klarnaAddr->getStreet());
        $this->klarnaAddr->setStreet(987);
        $this->assertEquals("987", $this->klarnaAddr->getStreet());
    }
    /**
     * @expectedException KlarnaException
     */
    public function testStreetException() {
        $this->assertNull($this->klarnaAddr->setStreet(""));
    }

    public function testZipCode() {
        $this->assertEquals("23634", $this->klarnaAddr->getZipCode());
        $this->klarnaAddr->setZipCode("12 149");
        $this->assertEquals("12149", $this->klarnaAddr->getZipCode());
    }

    /**
     * @expectedException KlarnaException
     */
    public function testZipCodeException() {
        $this->assertNull($this->klarnaAddr->setZipCode(null));
    }

    public function testCity() {
        $this->assertEquals("Hollviken", $this->klarnaAddr->getCity());
        $this->klarnaAddr->setCity(654);
        $this->assertEquals("654", $this->klarnaAddr->getCity());
    }

    /**
     * @expectedException KlarnaException
     */
    public function testCityException() {
        $this->assertNull($this->klarnaAddr->setCity(""));
    }

    public function dataProviderTestCountry() {
        return array(
            array(KlarnaCountry::SE, "se"),
            array(KlarnaCountry::NO, "no"),
            array(KlarnaCountry::DK, "dk"),
            array(KlarnaCountry::FI, "fi"),
            array(KlarnaCountry::DE, "de"),
            array(KlarnaCountry::NL, "nl"),
        );
    }

    /**
     * @dataProvider dataProviderTestCountry
     * @param int       $result
     * @param string    $countryCode
     */
    public function testCountry($result, $countryCode) {
        $this->assertEquals(KlarnaCountry::SE, $this->klarnaAddr->getCountry());
        $this->klarnaAddr->setCountry($countryCode);
        $this->assertEquals($result, $this->klarnaAddr->getCountry());
    }

    public function dataProviderTestCountryException() {
        return array(
            array("AA"),
            array(null),
            array(true),
        );
    }

    /**
     * @dataProvider dataProviderTestCountryException
     * @expectedException KlarnaException
     */
    public function testCountryException($country) {
        $this->assertNull($this->klarnaAddr->setCountry($country));
    }

    public function dataProviderCountryCode() {
        return array(
            array("se", KlarnaCountry::SE),
            array("no", KlarnaCountry::NO),
            array("dk", KlarnaCountry::DK),
            array("fi", KlarnaCountry::FI),
            array("de", KlarnaCountry::DE),
            array("nl", KlarnaCountry::NL),
        );
    }

    /**
     * @dataProvider dataProviderCountryCode
     * @param string    $result
     * @param int       $code
     */
    public function testCountryCode($result, $code) {
        $this->klarnaAddr->setCountry($code);
        $this->assertEquals($result, $this->klarnaAddr->getCountryCode());
    }

    /**
     * @expectedException KlarnaException
     */
    public function testCountryCodeException() {
        $this->klarnaAddr->setCountry("99999");
        $this->assertNull($this->klarnaAddr->getCountryCode());
    }

    public function dataProviderTestHouseNo() {
        return array(
            array("11", "11", KlarnaCountry::SE),
            array("11", 11, KlarnaCountry::SE),
            array("12", "12", KlarnaCountry::NO),
            array("12", 12, KlarnaCountry::NO),
            array("13", "13", KlarnaCountry::DK),
            array("13", 13, KlarnaCountry::DK),
            array("14", "14", KlarnaCountry::FI),
            array("14", 14, KlarnaCountry::FI),
            array("15", "15", KlarnaCountry::DE),
            array("15", 15, KlarnaCountry::DE),
            array("16", "16", KlarnaCountry::NL),
            array("16", 16, KlarnaCountry::NL),
        );
    }

    /**
     * @dataProvider dataProviderTestHouseNo
     * @param string    $result
     * @param string    $houseNo
     * @param int       $country
     */
    public function testHouseNo($result, $houseNo, $country ) {
        $this->assertEquals("houseNo", $this->klarnaAddr->getHouseNumber());
        $this->klarnaAddr->setCountry($country);
        $this->klarnaAddr->setHouseNumber($houseNo);
        $this->assertEquals("$result", $this->klarnaAddr->getHouseNumber());
    }

    public function testHouseExt() {
        $this->assertEquals("houseExt", $this->klarnaAddr->getHouseExt());
        $this->klarnaAddr->setHouseExt(123);
        $this->assertEquals("123", $this->klarnaAddr->getHouseExt());
    }

    public function testToArray() {
        $arr = array(
            'email'           => "karl.lidin@klarna.com",
            'telno'           => "0765260000",
            'cellno'          => "0765260000",
            'fname'           => "Karl",
            'lname'           => "Lidin",
            'company'         => "",
            'careof'          => "careof",
            'street'          => "Junibacksg 42",
            'house_number'    => "houseNo",
            'house_extension' => "houseExt",
            'zip'             => "23634",
            'city'            => "Hollviken",
            'country'         => "209",
        );
        $this->assertEquals($arr, $this->klarnaAddr->toArray());
    }
}
?>
