<?php
//~ require_once 'vfsStream/vfsStream.php';
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc.inc');
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc_wrappers.inc');
require_once('../Klarna.php');

/**
 * Test class for Klarna.
 * Generated by PHPUnit on 2011-01-28 at 09:47:44.
 */
class KlarnaTest extends PHPUnit_Framework_TestCase {

    /**
     * @var Klarna
     */
    protected $klarna;

    public static function setUpBeforeClass() {
        date_default_timezone_set('Europe/Stockholm');
    }

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->klarna = new Klarna();
        $this->klarna->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, "xml", dirname(__FILE__) . '/pclass.xml');
        $_SESSION = array();
        $this->klarna->setSessionID(0, "sid");
        Klarna::$disableXMLRPC = true;
        //Klarna::$debug = true;
        $_SERVER['REMOTE_ADDR'] = "127.0.0.1";

        vfsStreamWrapper::register();
        vfsStream::setup('testDir');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        unset($this->klarna);
    }

    public function dataProviderTestConfig() {
        return array(
            array("1029", "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA),
            array("3107", "vSscOjjWPheE63R", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::LIVE),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestConfig
     * @param <type> $eid
     * @param <type> $secret
     * @param <type> $country
     * @param <type> $language
     * @param <type> $currency
     * @param <type> $mode
     */
    public function testConfig($eid, $secret, $country, $language, $currency, $mode) {
        $this->assertNull($this->klarna->config($eid, $secret, $country, $language, $currency, $mode));
    }

    public function dataProviderTestConfigException() {
        return array(
            array(-1, "", "", "", ""),
            array(0, "", "", "", ""),
            array(1029, "", "", "", ""),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestConfigException
     * @expectedException KlarnaException
     * @param <type> $eid
     * @param <type> $secret
     * @param <type> $country
     * @param <type> $language
     * @param <type> $currency
     * @param <type> $mode
     * @param <type> $pcStorage
     * @param <type> $pcURI
     * @param <type> $ssl
     * @param <type> $candice
     */
    public function testConfigException($eid, $secret, $country, $language, $currency) {
        $this->assertNull($this->klarna->config($eid, $secret, $country, $language, $currency));
    }

    public function dataProviderTestSetConfig() {
        $config1 = new KlarnaConfig();
        $config1['eid'] = "1029";
        $config1['secret'] = "ALSyKSaQupJWAUK";
        $config1['country'] = KlarnaCountry::SE;
        $config1['language'] = KlarnaLanguage::SV;
        $config1['currency'] = KlarnaCurrency::SEK;
        $config1['mode'] = Klarna::BETA;
        $config1['pcStorage'] = 'json';
        $config1['pcURI'] = dirname(__FILE__) . '/data/beta-pclasses.json';

        $config2 = new KlarnaConfig();
        $config2['eid'] = "3107";
        $config2['secret'] = "vSscOjjWPheE63R";
        $config2['country'] = KlarnaCountry::SE;
        $config2['language'] = KlarnaLanguage::SV;
        $config2['currency'] = KlarnaCurrency::SEK;
        $config2['mode'] = Klarna::LIVE;
        $config2['pcStorage'] = 'xml';
        $config2['pcURI'] = dirname(__FILE__) . '/data/beta-pclasses.xml';

        return array(
            array($config1),
            array($config2),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetConfig
     * @param <type> $config
     */
    public function testSetConfig($config) {

        $this->assertNull($this->klarna->setConfig($config));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testSetConfigException() {
        $array = array();
        $this->assertNull($this->klarna->setConfig($array));
    }

    public function dataProviderTestSetCountry() {
        return array(
            array("1"),
            array(1),
            array("se"),
            array("no"),
            array("dk"),
            array("fi"),
            array("de"),
            array("nl"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetCountry
     * @param int $country
     */
    public function testSetCountry($country) {
        $this->assertNull($this->klarna->setCountry($country));
    }

    public function dataProviderTestGetCountryCode() {
        return array(
            array("se", KlarnaCountry::SE),
            array("no", KlarnaCountry::NO),
            array("dk", KlarnaCountry::DK),
            array("fi", KlarnaCountry::FI),
            array("de", KlarnaCountry::DE),
            array("nl", KlarnaCountry::NL),
            array("", 999),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetCountryCode
     * @param string $result
     * @param int    $country
     */
    public function testGetCountryCode($result, $country) {
        $this->klarna->setCountry($country);
        $this->assertEquals($result, $this->klarna->getCountryCode());
    }

    public function dataProviderTestSetCountryException() {
        return array(
            array(""),
            array("a"),
            array("aa"),
            array(null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetCountryException
     * @expectedException KlarnaException
     * @param int $country
     */
    public function testSetCountryException($country) {
        $this->assertNull($this->klarna->setCountry($country));
    }

    public function dataProviderTestGetCountry() {
        return array(
            array(209, KlarnaCountry::SE),
            array(164, KlarnaCountry::NO),
            array(59, KlarnaCountry::DK),
            array(73, KlarnaCountry::FI),
            array(81, KlarnaCountry::DE),
            array(154, KlarnaCountry::NL),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetCountry
     */
    public function testGetCountry($result, $country) {
        $this->klarna->setCountry($country);
        $this->assertEquals($result, $this->klarna->getCountry());
    }

    public function dataProviderTestSetLanguage() {
        return array(
            array(1),
            array('1'),
            array('da'),
            array('de'),
            array('fi'),
            array('nb'),
            array('nb'),
            array('nl'),
            array('sv'),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetLanguage
     * @param int $lang
     */
    public function testSetLanguage($lang) {
        $this->assertNull($this->klarna->setLanguage($lang));
    }

    public function dataProviderTestSetLanguageException() {
        return array(
            array(""),
            array("a"),
            array("aa"),
            array(null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetLanguageException
     * @expectedException KlarnaException
     * @param int $lang
     */
    public function testSetLanguageException($lang) {
        $this->assertNull($this->klarna->setLanguage($lang));
    }

    public function dataProviderTestGetLanguageCode() {
        return array(
            array("sv", KlarnaLanguage::SV),
            array("nb", KlarnaLanguage::NB),
            array("da", KlarnaLanguage::DA),
            array("fi", KlarnaLanguage::FI),
            array("de", KlarnaLanguage::DE),
            array("nl", KlarnaLanguage::NL),
            array("", 999),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetLanguageCode
     * @param string $result
     * @param int    $language
     */
    public function testGetLanguageCode($result, $language) {
        $this->klarna->setLanguage($language);
        $this->assertEquals($result, $this->klarna->getLanguageCode());
    }

    /**
     * @group allPHP
     */
    public function testGetLanguage() {
        $this->klarna->setLanguage(KlarnaLanguage::SV);
        $this->assertEquals(138, $this->klarna->getLanguage());
    }

    public function dataProviderTestSetCurrency() {
        return array(
            array(1),
            array("1"),
            array("dkk"),
            array("eur"),
            array("nok"),
            array("sek"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetCurrency
     * @param int $curr
     */
    public function testSetCurrency($curr) {
        $this->assertNull($this->klarna->setCurrency($curr));
    }

    public function dataProviderTestSetCurrencyException() {
        return array(
            array(""),
            array("a"),
            array("aaa"),
            array(null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetCurrencyException
     * @expectedException KlarnaException
     * @param int $curr
     */
    public function testSetCurrencyException($curr) {
        $this->assertNull($this->klarna->setCurrency($curr));
    }

    public function dataProviderTestGetCurrencyCode() {
        return array(
            array("sek", KlarnaCurrency::SEK),
            array("nok", KlarnaCurrency::NOK),
            array("dkk", KlarnaCurrency::DKK),
            array("eur", KlarnaCurrency::EUR),
            array("", 999),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetCurrencyCode
     * @param string $result
     * @param int    $currency
     */
    public function testGetCurrencyCode($result, $currency) {
        $this->klarna->setCurrency($currency);
        $this->assertEquals($result, $this->klarna->getCurrencyCode());
    }

    public function dataProviderTestGetCurrency() {
        return array(
            array(0, KlarnaCurrency::SEK),
            array(1, KlarnaCurrency::NOK),
            array(3, KlarnaCurrency::DKK),
            array(2, KlarnaCurrency::EUR),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetCurrency
     */
    public function testGetCurrency($result, $country) {
        $this->klarna->setCurrency($country);
        $this->assertEquals($result, $this->klarna->getCurrency());
    }

    public function dataProviderTestCheckCountryCurrency() {
        return array(
            array(true, KlarnaCountry::SE, KlarnaCurrency::SEK),
            array(true, KlarnaCountry::DK, KlarnaCurrency::DKK),
            array(true, KlarnaCountry::NO, KlarnaCurrency::NOK),
            array(true, KlarnaCountry::FI, KlarnaCurrency::EUR),
            array(true, KlarnaCountry::DE, KlarnaCurrency::EUR),
            array(true, KlarnaCountry::NL, KlarnaCurrency::EUR),
            array(false, KlarnaCountry::SE, KlarnaCurrency::EUR),
            array(false, KlarnaCountry::NO, KlarnaCurrency::EUR),
            array(false, KlarnaCountry::DK, KlarnaCurrency::EUR),
            array(false, KlarnaCountry::DE, KlarnaCurrency::SEK),
            array(false, KlarnaCountry::NL, KlarnaCurrency::SEK),
            array(true, "SE", "SEK"),
            array(false, "", ""),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestCheckCountryCurrency
     * @param <type> $result
     * @param <type> $country
     * @param <type> $currency
     */
    public function testCheckCountryCurrency($result, $country, $currency) {
        $this->assertEquals($result, $this->klarna->checkCountryCurrency($country, $currency));
    }

    /**
     * @group allPHP
     */
    public function testCheckCountryCurrencyNullParams(){
        $this->klarna->setCountry(KlarnaCountry::SE);
        $this->klarna->setCurrency(KlarnaCurrency::SEK);
        $this->assertTrue($this->klarna->checkCountryCurrency());
    }

    /**
     * @group allPHP
     */
    public function testGetLanguageForCountryNullParams() {
        //Takes the value used in setup()
        $this->assertEquals(138, $this->klarna->getLanguageForCountry());
    }

    /**
     * @group allPHP
     */
    public function testGetCurrencyForCountryNullParams() {
        //Takes the value used in setup()
        $this->assertEquals(0, $this->klarna->getCurrencyForCountry());
    }

    public function dataProviderTestSetSessionID() {
        return array(
            array("1", "2"),
            array("1", "a"),
            array(1, 2),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetSessionID
     * @param int $type
     * @param string $sid
     */
    public function testSetSessionID($type, $sid) {
        $this->assertNull($this->klarna->setSessionID($type, $sid));
    }

    public function dataProviderTestSetSessionIDException() {
        return array(
            array("", ""),
            array("1", ""),
            array(1, ""),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetSessionIDException
     * @expectedException KlarnaException
     * @param int $type
     * @param string $sid
     */
    public function testSetSessionIDException($type, $sid) {
        $this->assertNull($this->klarna->setSessionID($type, $sid));
    }

    /**
     * @group allPHP
     */
    public function testSetShipmentInfo() {
        $this->assertNull($this->klarna->setShipmentInfo("name", "value"));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testSetShipmentInfoException() {
        $this->assertNull($this->klarna->setShipmentInfo(null, null));
    }

    /**
     * @group allPHP
     */
    public function testSetExtraInfo() {
        $this->assertNull($this->klarna->setExtraInfo("name", "value"));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testSetExtraInfoException() {
        $this->assertNull($this->klarna->setExtraInfo(null, null));
    }

    /**
     * @group allPHP
     */
    public function testSetIncomeInfo() {
        $this->assertNull($this->klarna->setIncomeInfo("name", "value"));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testSetIncomeInfoException() {
        $this->assertNull($this->klarna->setIncomeInfo(null, null));
    }

    /**
     * @group allPHP
     */
    public function testSetBankInfo() {
        $this->assertNull($this->klarna->setBankInfo("name", "value"));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testSetBankInfoException() {
        $this->assertNull($this->klarna->setBankInfo(null, null));
    }

    public function testSetTravelInfo() {
        $this->assertNull($this->klarna->setTravelInfo("name", "value"));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testSetTravelInfoException() {
        $this->assertNull($this->klarna->setTravelInfo(null, null));
    }

    public function getAddressArray($tag) {
        $dom = new DOMDocument('1.0', 'UTF-8');
        $file = dirname(__FILE__).'/data/UnitPersonTestList.xml';
        if (!$dom->load($file)) {
            echo "Failed to load";
        }
        $xpath = new DOMXpath($dom);

        $query = "/root/" . $tag . "[@id='Persons']/child::node()";
        $tmp = array();
        foreach ($xpath->query($query) as $node) {
            if (!($node instanceof DOMElement)) continue;
            $fnameNode = $xpath->query('//FNAME', $node)->item(0);
            $lnameNode = $xpath->query('//LNAME', $node)->item(0);
            $careof = "";
            $streetNode = $xpath->query('//ADDRESS', $node)->item(0);
            $zipNode = $xpath->query('//POST_NUMBER', $node)->item(0);
            $cityNode = $xpath->query('//CITY', $node)->item(0);
            $countryNode = $xpath->query('//COUNTRY', $node)->item(0);
            $houseNoNode = $xpath->query('//ADDR_NUMBER', $node)->item(0);
            $tmp[] = array(
                $fnameNode->nodeValue,
                $lnameNode->nodeValue,
                $careof,
                $streetNode->nodeValue,
                $zipNode->nodeValue,
                $cityNode->nodeValue,
                $countryNode->nodeValue,
                $houseNoNode->nodeValue,
            );
        }
        return $tmp;
    }

    public function dataProviderSetAddressValid() {
        return $this->getAddressArray('VALID');
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderSetAddressValid
     * @param <type> $fname
     * @param <type> $lname
     * @param <type> $careof
     * @param <type> $street
     * @param <type> $zip
     * @param <type> $city
     * @param <type> $houseNo
     */
    public function testSetAddressValid($fname, $lname, $careof, $street, $zip, $city, $country, $houseNo) {
        $addr = new KlarnaAddr($fname, $lname, $careof, $street, $zip, $city, $country, $houseNo);
        $this->assertNull($this->klarna->setAddress(KlarnaFlags::IS_BILLING, $addr));
        $this->assertNull($this->klarna->setAddress(KlarnaFlags::IS_SHIPPING, $addr));
    }

    public function dataProviderSetAddressInvalid() {
        return $this->getAddressArray('INVALID');
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderSetAddressInvalid
     * @param <type> $fname
     * @param <type> $lname
     * @param <type> $careof
     * @param <type> $street
     * @param <type> $zip
     * @param <type> $city
     * @param <type> $houseNo
     */
    public function testSetAddressInvalid($fname, $lname, $careof, $street, $zip, $city, $country, $houseNo) {
        $addr = new KlarnaAddr($fname, $lname, $careof, $street, $zip, $city, $country, $houseNo);
        $this->assertNull($this->klarna->setAddress(KlarnaFlags::IS_BILLING, $addr));
        $this->assertNull($this->klarna->setAddress(KlarnaFlags::IS_SHIPPING, $addr));
    }

    public function dataProviderTestSetAddressException() {
        return array(
            array("", "", "", "", "", "", "", "", ""),
            array(1111, "", "", "", "", "", "", "", ""),
            array(null, "", "", "", "", "", "", "", ""),
            array("Karl", "", "", "", "", "", "", "", ""),
            array("Karl", 2222, "", "", "", "", "", "", ""),
            array("Karl", null, "", "", "", "", "", "", ""),
            array("Karl", "Lidin", "", "", "", "", "", "", ""),
            array("Karl", "Lidin", 3333, "", "", "", "", "", ""),
            array("Karl", "Lidin", null, "", "", "", "", "", ""),
            array("Karl", "Lidin", "careOf", "", "", "", "", "", ""),
            array("Karl", "Lidin", "careOf", 4444, "", "", "", "", ""),
            array("Karl", "Lidin", "careOf", null, "", "", "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "", "", "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", " ", "", "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", 5555, "", "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", null, "", "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "", "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", 6666, "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", null, "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "", "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", 7777, "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", null, "", ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "14", 8888, ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "14", null, ""),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "14", "Ext", 9999),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "14", "Ext", null),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "", "Ext", KlarnaFlags::IS_BILLING, KlarnaCountry::NL),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "", "Ext", KlarnaFlags::IS_SHIPMENT, KlarnaCountry::NL),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "", "Ext", KlarnaFlags::IS_BILLING, KlarnaCountry::DE),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "", "Ext", KlarnaFlags::IS_SHIPMENT, KlarnaCountry::DE),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "14", "Ext", 999999999999999999999999, KlarnaCountry::DE),
            array("Karl", "Lidin", "careOf", "Junibacksg 42", "23634", "Hollviken", "14", "Ext", KlarnaFlags::IS_SHIPMENT, KlarnaCountry::DE, false),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSetAddressException
     * @expectedException KlarnaException
     * @param string $fname
     * @param string $lname
     * @param string $careof
     * @param string $street
     * @param string $zip
     * @param string $city
     * @param string $houseNo
     * @param string $houseExt
     * @param string $type
     */
    public function testSetAddressException($fname, $lname, $careof, $street, $zip, $city, $houseNo, $houseExt, $type, $country = "", $add = true) {
        if (is_int($country)) $this->klarna->setCountry($country);
        if ($add )$addr = new KlarnaAddr($fname, $lname, $careof, $street, $zip, $city, $country, $houseNo, $houseExt);
        else $addr = null;
        $this->assertNull($this->klarna->setAddress($type, $addr));
    }

    /**
     * @group allPHP
     */
    public function testSetEstoreInfo() {
        $this->assertNull($this->klarna->setEstoreInfo("orderid1", "orderid2", "user"));
        $this->assertNull($this->klarna->setEstoreInfo(1111111111, 2222222222, 333333));
    }

    /**
     * @group allPHP
     */
    public function testSetReference() {
        $this->assertNull($this->klarna->setReference("ref", "code"));
    }

    /**
     * @group allPHP
     */
    public function testGetReference() {
        $this->klarna->setReference('Reference', 'Code');
        $this->assertEquals('Reference', $this->klarna->getReference());
    }

    /**
     * @group allPHP
     */
    public function testSetComment() {
        $this->assertNull($this->klarna->setComment('Comment'));
    }

    /**
     * @group allPHP
     */
    public function testAddComment() {
        $this->assertNull($this->klarna->addComment('Another comment'));
    }

    public function dataProviderGetPNOEncoding() {
        return array(
            array(KlarnaEncoding::PNO_SE, KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK),
            array(KlarnaEncoding::PNO_NO, KlarnaCountry::NO, KlarnaLanguage::NB, KlarnaCurrency::NOK),
            array(KlarnaEncoding::PNO_FI, KlarnaCountry::FI, KlarnaLanguage::FI, KlarnaCurrency::EUR),
            array(KlarnaEncoding::PNO_DK, KlarnaCountry::DK, KlarnaLanguage::DA, KlarnaCurrency::DKK),
            array(KlarnaEncoding::PNO_DE, KlarnaCountry::DE, KlarnaLanguage::DE, KlarnaCurrency::EUR),
            array(KlarnaEncoding::PNO_NL, KlarnaCountry::NL, KlarnaLanguage::NL, KlarnaCurrency::EUR),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderGetPNOEncoding
     * @param int $result
     * @param int $enc
     * @param int $lang
     * @param int $curr
     */
    public function testGetPNOEncoding($result, $country, $lang, $curr) {
        $klarna = new Klarna();
        $klarna->config(1029, "ALSyKSaQupJWAUK", $country, $lang, $curr, Klarna::BETA);
        $this->assertEquals($result, $klarna->getPNOEncoding());
    }

    /**
     * @group allPHP
     * @return multitype:multitype:NULL  multitype:number string  multitype:number
     */
    public function dataProviderGetPNOEncodingException() {
        return array(
            array(KlarnaCountry::SE, KlarnaLanguage::SV, 999),
            array(KlarnaCountry::SE, 999, KlarnaCurrency::SEK),
            array(KlarnaCountry::NO, KlarnaLanguage::NB, 999),
            array(KlarnaCountry::NO, 999, KlarnaCurrency::NOK),
            array(KlarnaCountry::FI, KlarnaLanguage::FI, 999),
            array(KlarnaCountry::FI, 999, KlarnaCurrency::EUR),
            array(KlarnaCountry::DK, KlarnaLanguage::DA, 999),
            array(KlarnaCountry::DK, 999, KlarnaCurrency::DKK),
            array(KlarnaCountry::DE, KlarnaLanguage::DE, 999),
            array(KlarnaCountry::DE, 999, KlarnaCurrency::EUR),
            array(KlarnaCountry::NL, KlarnaLanguage::NL, 999),
            array(KlarnaCountry::NL, 999, KlarnaCurrency::EUR),
            array(999, KlarnaLanguage::SV, KlarnaCurrency::SEK),
            array(999, KlarnaLanguage::NB, KlarnaCurrency::NOK),
            array(999, KlarnaLanguage::FI, KlarnaCurrency::EUR),
            array(999, KlarnaLanguage::DA, KlarnaCurrency::DKK),
            array(999, KlarnaLanguage::DE, KlarnaCurrency::EUR),
            array(999, KlarnaLanguage::NL, KlarnaCurrency::EUR),
            array(null, null, null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderGetPNOEncodingException
     * @expectedException KlarnaException
     * @param int $country
     * @param int $lang
     * @param int $curr
     */
    public function testGetPNOEncodingException($country, $lang, $curr) {
        $klarna = new Klarna();
        $klarna->config(1029, "ALSyKSaQupJWAUK", $country, $lang, $curr, Klarna::BETA);
        $this->assertNull($klarna->getPNOEncoding());
    }

    public function dataProviderTestGetAddresses() {
        $addr1 = array("Karl", "Lidin", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE);
        $addr2 = array("", "Kalle Anka AB", "Storgatan 1", "12345", "Ankeborg", KlarnaCountry::SE);
        $addr3 = array("Lidin", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE);
        $addr4 = array("Kalle Anka AB", "Storgatan 1", "12345", "Ankeborg", KlarnaCountry::SE);
        return array(
            array("430415-8399", KlarnaEncoding::PNO_SE, array($addr1), KlarnaFLags::GA_ALL),
            array("430415-8399", null, array($addr2), KlarnaFLags::GA_ALL),
            array("430415-8399", null, array($addr1), 999),
            array("430415-8399", null, array($addr3), KlarnaFLags::GA_LAST),
            array("430415-8399", null, array($addr1), KlarnaFLags::GA_GIVEN),
            array("430415-8399", null, array($addr4), KlarnaFLags::GA_GIVEN),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetAddresses
     * @param string $pno
     * @param string $encoding
     */
    public function testGetAddresses($pno, $encoding, $addr, $type) {
        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($addr));
        $klarnaStub->setCountry(KlarnaCountry::SE);
        $klarnaStub->setLanguage(KlarnaLanguage::SV);
        $klarnaStub->setCurrency(KlarnaCurrency::SEK);
        //if($pno == false) $klarnaStub->setCustomer("430415-8399", "Karl", "Lidin", "0765260000", "0765260000", "karl.lidin@klarna.com");
        $this->assertInternalType('array', $klarnaStub->getAddresses($pno, $encoding, $type));
    }

    public function dataProviderTestGetAddressesException() {
        return array(
            array("", "", ""),
            array("430415-8399", "", ""),
            array(null, "127.0.0.1", ""),
            array("430415-8399", "127.0.0.1", "", KlarnaCountry::DE),
            array("430415-8399", "127.0.0.1", "", KlarnaCountry::DE),
            array("430415", "127.0.0.1", ""),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetAddressesException
     * @expectedException KlarnaException
     * @param string $pno
     * @param string $ip
     * @param int $type
     * @param int $country
     */
    public function testGetAddressesException($pno, $ip, $type, $country = KlarnaCountry::SE) {
        $this->klarna->setCountry($country);
        $this->assertNull($this->klarna->getAddresses($pno, $ip, $type));
    }

    /**
     * @group allPHP
     */
    public function testAddArticle() {
        $this->assertNull($this->klarna->addArticle(1, "111", "artTitle", 100, 25));
    }

    public function dataProviderTestAddArticleException() {
        return array(
            array("", "", "", "", "", "", ""),
            array(null, "", "", "", "", "", ""),
            array("1", "", "", "", "", "", ""),
            array(1, null, "", "", "", "", ""),
            array(1, "artNo", "", "", "", "", ""),
            array(1, "11111", "", "", "", "", ""),
            array(1, "11111", null, "", "", "", ""),
            array(1, null, null, "", "", "", ""),
            array(1, 11111, 111111111, "", "", "", ""),
            array(1, 11111, "artTitle", "", "", "", ""),
            array(1, 11111, "artTitle", null, "", "", ""),
            array(1, 11111, "artTitle", "100", "", "", ""),
            array(1, 11111, "artTitle", 100, "", "", ""),
            array(1, 11111, "artTitle", 100, null, "", ""),
            array(1, 11111, "artTitle", 100, "vat", "", ""),
            array(1, 11111, "artTitle", 100, 25, null, ""),
            array(1, 11111, "artTitle", 100, 25, "discount", ""),
            array(1, 11111, "artTitle", 100, 25, 10, null),
            array(1, 11111, "artTitle", 100, 25, 10, "flags"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestAddArticleException
     * @expectedException KlarnaException
     * @param  int       $qty       quantity.
     * @param  string    $artNo     article number.
     * @param  string    $artTitle  article title.
     * @param  int       $price     article price.
     * @param  int       $vat       VAT in percent
     * @param  int       $discount  Discount
     * @param  int       $flag      Klarna flag.
     */
    public function testAddArticleException($qty, $artNo, $artTitle, $price, $vat, $dicount, $flag) {
        $this->assertNull($this->klarna->addArticle($qty, $artNo, $artTitle, $price, $vat, $dicount, $flag));
    }

    public function dataProviderTestAddTransaction() {
        return array(
            array(KlarnaFlags::NO_FLAG, "shipping"),
            array(KlarnaFlags::TEST_MODE, "billing"),
            array(KlarnaFlags::AUTO_ACTIVATE, "company"),
            array(KlarnaFlags::PRE_PAY, "shipping"),
            //array(KlarnaFlags::FAPI_EXTRA, "billing"),
            array(KlarnaFlags::SENSITIVE_ORDER, "company"),
            array(KlarnaFlags::RETURN_OCR, "shipping"),
            //array(KlarnaFlags::FAPI_EXTRA_GOODS, "billing"),
            array(KlarnaFlags::M_PHONE_TRANSACTION, "company"),
            array(KlarnaFlags::M_SEND_PHONE_PIN),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestAddTransaction
     */
    public function testAddTransaction($flags, $case = 0) {
        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $conf = new KlarnaConfig();
        $conf['eid'] = "1029";
        $conf['secret'] = "ALSyKSaQupJWAUK";
        $conf['country'] = KlarnaCountry::SE;
        $conf['language'] = KlarnaLanguage::SV;
        $conf['currency'] = KlarnaCurrency::SEK;
        $conf['mode'] = Klarna::BETA;
        $conf['ssl'] = true;
        $conf['candice'] = true;
        $conf['pcStorage'] = 'json';
        $conf['pcURI'] = dirname(__FILE__) . '/data/addTransaction.json';
        $klarnaStub->setConfig($conf);
        $pcArray = array(array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"));
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->onConsecutiveCalls($pcArray, "addTransaction result"));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency()); //First xmlrpc_call

        $addr = new KlarnaAddr("karl.lidin@klarna.com", "0765260000", "0765260000", "Karl", "Lidin", "careof", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE, "houseNo", "houseExt");
        $klarnaStub->addArticle("2", "artNo", "artTitle", 100, 25, 0, KlarnaFlags::NO_FLAG);
        switch ($case) {
            case "shipping":
                $klarnaStub->setAddress(KlarnaFlags::IS_SHIPPING, $addr);
                break;
            case "billing":
                $klarnaStub->setAddress(KlarnaFlags::IS_BILLING, $addr);
                break;
            case "company":
                $addr = new KlarnaAddr();
                $addr->isCompany = true;
                $addr->setEmail("karl.lidin@klarna.com");
                $addr->setFirstName("Karl");
                $addr->setLastName("Lidin");
                $addr->setCompanyName("Kalle Anka AB");
                $addr->setStreet("Storgatan 1");
                $addr->setZipCode("12345");
                $addr->setCity("Ankeborg");
                $addr->setCountry(KlarnaCountry::SE);
                $klarnaStub->setAddress(KlarnaFlags::IS_SHIPPING, $addr);
                break;
            default:
                $klarnaStub->setAddress(KlarnaFlags::IS_SHIPPING, $addr);
                $klarnaStub->setAddress(KlarnaFlags::IS_BILLING, $addr);
                break;
        }
        //Second xmlrpc_call
        $this->assertEquals("addTransaction result", $klarnaStub->addTransaction("430415-8399", KlarnaFlags::MALE, $flags, "390"));
    }

    public function dataProviderTestAddTransactionException() {
        return array(
            array(FALSE, FALSE, FALSE), // No articles in goods list!
            array(FALSE, FALSE, TRUE), // No address set!
            array(TRUE, TRUE, TRUE), // Shipping address country must match the country set!
            array(TRUE, TRUE, TRUE, TRUE), // You must set country, language and currency!
        );
    }

    /**
     * @group allPHP
     * @todo testAddTransactionException : Shipping address country must match the country set!
     * @dataProvider dataProviderTestAddTransactionException
     * @expectedException KlarnaException
     */
    public function testAddTransactionException($addressBilling = FALSE, $addressShipping = FALSE, $article = FALSE, $stub = FALSE) {
        $addr1 = new KlarnaAddr("karl.lidin@klarna.com", "0765260000", "0765260000", "Karl", "Lidin", "careof", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE, "houseNo", "houseExt");
        $addr2 = new KlarnaAddr("test.persoon@klarna.com", "0612345678", "0612345678", "Test", "Persoon", "careof", "Neherkade 1", "2521VA", "Gravenhage", KlarnaCountry::NL, "houseNo", "houseExt");
        if ($addressBilling) $this->klarna->setAddress(KlarnaFlags::IS_BILLING, $addr1);
        if ($addressShipping) $this->klarna->setAddress(KlarnaFlags::IS_SHIPPING, $addr2);
        if ($article) $this->klarna->addArticle("2", "13", "artTitle", 100, 25);
        if (!$stub) $this->assertNull($this->klarna->addTransaction("430415-8399", KlarnaFlags::MALE));
        else {
            $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
            $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue("addTransaction result"));
            $conf = new KlarnaConfig();
            $conf['eid'] = "1029";
            $conf['secret'] = "ALSyKSaQupJWAUK";
//            $conf['country'] = KlarnaCountry::SE;
//            $conf['language'] = KlarnaLanguage::SV;
//            $conf['currency'] = KlarnaCurrency::SEK;
            $conf['mode'] = Klarna::BETA;
            $conf['ssl'] = true;
            $conf['candice'] = true;
            $conf['pcStorage'] = 'json';
            $conf['pcURI'] = dirname(__FILE__) . '/data/addTransaction.json';
            $klarnaStub->setConfig($conf);
            $this->assertNull($klarnaStub->addTransaction("430415-8399", KlarnaFlags::MALE));
        }
    }

    public function dataProviderActivateInvoice() {
        return array(
            array("123456"),
            array(654321),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderActivateInvoice
     * @param int/string $invNo
     */
    public function testActivateInvoice($invNo) {
        $this->assertTrue($this->klarna->activateInvoice($invNo));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testActivateInvoiceException() {
        $this->assertNull($this->klarna->activateInvoice(""));
    }

    public function dataProviderTestRemoveInvoice() {
        return array(
            array("123456"),
            array(654321),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestRemoveInvoice
     * @param int/string $invNo
     */
    public function testDeleteInvoice($invNo) {
        $this->assertTrue($this->klarna->deleteInvoice($invNo));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testDeleteInvoiceException() {
        $this->assertNull($this->klarna->deleteInvoice(""));
    }

    public function dataProviderTestReserveAmount() {
        $addr1 = new KlarnaAddr("karl.lidin@klarna.com", "0765260000", "0765260000", "Karl", "Lidin", "careof", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE, "houseNo", "houseExt");

        $addr2 = new KlarnaAddr();
        $addr2->isCompany = true;
        $addr2->setEmail("karl.lidin@klarna.com");
        $addr2->setTelno("0765260000");
        $addr2->setCellno("0765260000");
        $addr2->setFirstName("Karl");
        $addr2->setLastName("Lidin");
        $addr2->setCompanyName("Kalle Anka AB");
        $addr2->setStreet("Storgatan 1");
        $addr2->setZipCode("12345");
        $addr2->setCity("Ankeborg");
        $addr2->setCountry(KlarnaCountry::SE);

        return array(
            array("430415-8399", 100, "reference", "refCode", 10, $addr1),
            array("430415-8399", "100", "", "", array(10, 11), $addr1),
            array("430415-8399", -1, "", "", array(12, 13), $addr1),
            array("430415-8399", -1, "reference", "refCode", array(12, 13), $addr2),
        );
    }

    /**
     * @group allPHP
     * @todo testReserveAmount: $flags, $pclass, $encoding, $pin, $clear
     * @dataProvider dataProviderTestReserveAmount
     * @param int       $amount
     * @param int|array $orderId
     */
    public function testReserveAmount($pno, $amount, $reference, $redCode, $orderId, $addr) {
        //$this->klarna->setCustomer("430415-8399", "Karl", "Lidin", "0765260000", "0765260000", "karl.lidin@klarna.com");
        $this->klarna->setAddress(KlarnaFlags::IS_SHIPPING, $addr);
        $this->klarna->setAddress(KlarnaFlags::IS_BILLING, $addr);
        $this->klarna->addArticle(1, "111", "artTitle", 100, 25);
        $this->assertTrue($this->klarna->reserveAmount($pno, KlarnaFlags::MALE, $amount));
    }

    public function dataProviderTestReserveAmountException() {
        return array(
            array(null, null, "reference", "refCode"),
            array("430415-8399", "amount", "reference", "refCode"),
            array("430415-8399", "0", "reference", "refCode"),
            array("430415-8399", "1000", null, "refCode"),
            array("430415-8399", "1000", "reference", null),
            array("430415-8399", "1000", "reference", "refCode", FALSE),
            array("430415-8399", "1000", "reference", "refCode", TRUE, TRUE),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestReserveAmountException
     * @expectedException KlarnaException
     * @todo resrReserveAmountException : $flags, $pclass, $encoding, $pin, $clear
     * @param <type> $amount
     * @param <type> $reference
     * @param <type> $refCode
     * @param <type> $orderId
     * @param <type> $flags
     * @param <type> $pclass
     */
    public function testReserveAmountException($pno, $amount, $reference, $refCode, $goodsList = TRUE, $stub = FALSE) {
        if ($goodsList )$this->klarna->addArticle("2", "13", "artTitle", 100, 25);
        if (!$stub )$this->assertNull($this->klarna->reserveAmount($pno, KlarnaFlags::MALE, $amount));
        else {
            $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
            $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue("reserveAmount result"));
            $conf = new KlarnaConfig();
            $conf['eid'] = "1029";
            $conf['secret'] = "ALSyKSaQupJWAUK";
//            $conf['country'] = KlarnaCountry::SE;
//            $conf['language'] = KlarnaLanguage::SV;
//            $conf['currency'] = KlarnaCurrency::SEK;
            $conf['mode'] = Klarna::BETA;
            $conf['ssl'] = true;
            $conf['candice'] = true;
            $conf['pcStorage'] = 'json';
            $conf['pcURI'] = dirname(__FILE__) . '/data/reserveAmount.json';
            $klarnaStub->setConfig($conf);
            $this->assertNull($klarnaStub->reserveAmount("430415-8399", KlarnaFlags::MALE, "10000"));
        }
    }

    public function dataProviderTestCancelReservation() {
        return array(
            array("987654321"),
            array(987654321),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestCancelReservation
     * @param int $nNo
     */
    public function testCancelReservation($rno) {
        $this->assertTrue($this->klarna->cancelReservation($rno));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testCancelReservationException() {
        $this->assertNull($this->klarna->cancelReservation(""));
    }

    public function dataProviderTestChangeReservation() {
        return array(
            array("987654321", "200"),
            array(987654321, "200"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestChangeReservation
     * @param <type> $rno
     * @param <type> $amount
     */
    public function testChangeReservation($rno, $amount) {
        $this->assertTrue($this->klarna->changeReservation($rno, $amount));
    }

    public function dataProviderTestChangeReservationException() {
        $obj = new stdClass();
        return array(
            array("", ""),
            array("1", null),
//            array("1", $obj),
            array("1", "abc"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestChangeReservationException
     * @expectedException KlarnaException
     * @param <type> $rno
     * @param <type> $amount
     */
    public function testChangeReservationException($rno, $amount) {
        $this->assertNull($this->klarna->changeReservation($rno, $amount));
    }

    public function dataProviderTestActivateReservation() {
        return array(
            array("123456", "654321", "987", "789", "10"),
            array(123456, 654321, 987, 789, 10),
            array(123456, 654321, 987, 789, array(10, 11)),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestActivateReservation
     * @param <type> $rno
     * @param <type> $amount
     */
    public function testActivateReservation($rno, $ocr, $reference, $refCode, $orderId) {
        $return = array(
            '0' => "ok",
            '1' => "123456",
        );
        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($return));
        $conf = new KlarnaConfig();
        $conf['eid'] = "1029";
        $conf['secret'] = "ALSyKSaQupJWAUK";
        $conf['country'] = KlarnaCountry::SE;
        $conf['language'] = KlarnaLanguage::SV;
        $conf['currency'] = KlarnaCurrency::SEK;
        $conf['mode'] = Klarna::BETA;
        $conf['ssl'] = true;
        $conf['candice'] = true;
        $conf['pcStorage'] = 'json';
        $conf['pcURI'] = dirname(__FILE__) . '/data/beta-pclasses.json';
        $klarnaStub->setConfig($conf);
        $addr = new KlarnaAddr("karl.lidin@klarna.com", "0765260000", "0765260000", "Karl", "Lidin", "careof", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE, "houseNo", "houseExt");
        $klarnaStub->setAddress(KlarnaFlags::IS_SHIPPING, $addr);
        $klarnaStub->setAddress(KlarnaFlags::IS_BILLING, $addr);
        $klarnaStub->addArticle(1, "111", "artTitle", 100, 25);
        $result = array(
            '0' => "ok",
            '1' => "123456"
        );
        $this->assertEquals($result, $klarnaStub->activateReservation("430415-8399", $rno, $ocr, $reference, $refCode, $orderId));
    }

    public function dataProviderTestActivateReservationException() {
        return array(
            array(""),
            array(null),
            array("123"),
            array("123", TRUE, TRUE, FALSE),
            array("123", TRUE, TRUE, TRUE, TRUE),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestActivateReservationException
     * @expectedException KlarnaException
     */
    public function testActivateReservationException($rno, $addressBilling = TRUE, $addressShipping = TRUE, $article = TRUE, $stub = FALSE) {
        $addr1 = new KlarnaAddr("karl.lidin@klarna.com", "0765260000", "0765260000", "Karl", "Lidin", "careof", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE, "houseNo", "houseExt");
        $addr2 = new KlarnaAddr("test.persoon@klarna.com", "0612345678", "0612345678", "Test", "Persoon", "careof", "Neherkade 1", "2521VA", "Gravenhage", KlarnaCountry::NL, "houseNo", "houseExt");
        if ($addressBilling) $this->klarna->setAddress(KlarnaFlags::IS_BILLING, $addr1);
        if ($addressShipping) $this->klarna->setAddress(KlarnaFlags::IS_SHIPPING, $addr2);
        if ($article) $this->klarna->addArticle("2", "13", "artTitle", 100, 25);
        if (!$stub )$this->assertNull($this->klarna->activateReservation("430415-8399", $rno, KlarnaFlags::MALE));
        else {
            $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
            $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue("activateReservation result"));
            $conf = new KlarnaConfig();
            $conf['eid'] = "1029";
            $conf['secret'] = "ALSyKSaQupJWAUK";
//            $conf['country'] = KlarnaCountry::SE;
//            $conf['language'] = KlarnaLanguage::SV;
//            $conf['currency'] = KlarnaCurrency::SEK;
            $conf['mode'] = Klarna::BETA;
            $conf['ssl'] = true;
            $conf['candice'] = true;
            $conf['pcStorage'] = 'json';
            $conf['pcURI'] = dirname(__FILE__) . '/data/activateReservation.json';
            $klarnaStub->setConfig($conf);
            $this->assertNull($klarnaStub->activateReservation("430415-8399", $rno, KlarnaFlags::MALE));
        }
    }

    public function dataProviderTestSplitReservation() {
        return array(
            array("123", "345", "10"),
            array(123, 345, array(11, 12)),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSplitReservation
     * @param <type> $rno
     * @param <type> $amount
     * @param <type> $orderId
     */
    public function testSplitReservation($rno, $amount, $orderId) {
        $this->assertTrue($this->klarna->splitReservation($rno, $amount, $orderId));
    }

    public function dataProviderTestSplitReservationException() {
        $obj = new stdClass();
        return array(
            array("123", null),
//            array("123", $obj),
            array("123", "abc"),
//            array($obj, "123"),
            array(null, "123"),
            array("123", "0"),
            array("123", null),
//            array("123", $obj),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSplitReservationException
     * @expectedException KlarnaException
     * @param <type> $rno
     * @param <type> $amount
     * @param <type> $orderId
     */
    public function testSplitReservationException($rno, $amount) {
        $this->assertNull($this->klarna->splitReservation($rno, $amount));
    }

    public function dataProviderTestReserveOCR() {
        return array(
            array("1234", KlarnaCountry::SE),
            array(1234, KlarnaCountry::NO),
            array(1234, KlarnaCountry::DK),
            array(1234, KlarnaCountry::FI),
            array(1234, KlarnaCountry::DE),
            array(1234, KlarnaCountry::NL),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestReserveOCR
     * @param int $no
     * @param int $country
     */
    public function testReserveOCR($no, $country) {
        $this->assertTrue($this->klarna->reserveOCR($no, $country));
        $this->klarna->setCountry($country);
        $this->assertTrue($this->klarna->reserveOCR($no, null));
    }

    public function dataProviderTestReserveOCRException() {
        return array(
            array("", ""),
            array(null, ""),
            array(123, ""),
            //array(123, null),
            array(0, KlarnaCountry::SE),
            array(null, null, TRUE),
        );
    }

    /**
     * @group allPHP
     * @todo testReserveOCRException : You must set country first! See config
     * @dataProvider dataProviderTestReserveOCRException
     * @expectedException KlarnaException
     * @param <type> $no
     * @param <type> $country
     */
    public function testReserveOCRException($no, $country, $stub = FALSE) {
        if (!$stub )$this->assertNull($this->klarna->reserveOCR($no, $country));
        else {
            $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
            $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue(null));
            $conf = new KlarnaConfig();
            $conf['eid'] = "1029";
            $conf['secret'] = "ALSyKSaQupJWAUK";
//            $conf['country'] = KlarnaCountry::SE;
//            $conf['language'] = KlarnaLanguage::SV;
//            $conf['currency'] = KlarnaCurrency::SEK;
            $conf['mode'] = Klarna::BETA;
            $conf['ssl'] = true;
            $conf['candice'] = true;
            $conf['pcStorage'] = 'json';
            $conf['pcURI'] = dirname(__FILE__) . '/data/reserveOCR.json';
            $klarnaStub->setConfig($conf);
            $this->assertNull($klarnaStub->reserveOCR($no, $country));
        }
    }

    /**
     * @group allPHP
     */
    public function testReserveOCRemail() {
        $klarnaMock = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaMock->expects($this->any())->method('xmlrpc_call')->will($this->returnValue('ok'));

        $this->assertTrue($this->klarna->reserveOCRemail(123, "karl.lidin@klarna.com", KlarnaCountry::SE));
        $this->klarna->setCountry(KlarnaCountry::SE);
        $this->assertTrue($this->klarna->reserveOCRemail(123, "karl.lidin@klarna.com", null));

        $this->setExpectedException('KlarnaException');
        $klarnaMock->reserveOCRemail("123", "karl.lidin@klarna.com", null);
    }

    /**
     * @group allPHP
     * @param string $pno
     */
    public function testHasAccount() {
        //No call is made, therefore this will be false. (disableXMLRPC)
        $this->assertFalse($this->klarna->hasAccount("430415-8399"));
    }

    public function dataProviderTestHasAccountException() {
        return array(
            array(""),
            array(null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestHasAccountException
     * @expectedException KlarnaException
     * @param string $pno
     */
    public function testHasAccountException($pno) {
        $this->assertNull($this->klarna->hasAccount($pno));
    }

    /**
     * @group allPHP
     */
    public function testAddArtNo() {
        $this->assertNull($this->klarna->addArtNo(1, "123"));
    }

    public function dataProviderTestAddArtNoException() {
        return array(
            array("", ""),
            array(null, ""),
            array("abc", ""),
            array(1, ""),
            array(1, null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestAddArtNoException
     * @expectedException KlarnaException
     * @param <type> $qty
     * @param <type> $artNo
     */
    public function testAddArtNoException($qty, $artNo) {
        $this->assertNull($this->klarna->addArtNo($qty, $artNo));
    }

    /**
     * @group allPHP
     */
    public function testActivatePart() {
        $this->klarna->addArtNo(1, 123);
        $this->assertTrue($this->klarna->activatePart(123));
    }

    public function dataProviderTestActivatePartException() {
        return array(
            array("", ""),
            array(null, ""),
            array("123", ""),
            array("123", null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestActivatePartException
     * @expectedException KlarnaException
     * @param <type> $invNo
     * @param <type> $artNos
     */
    public function testActivatePartException($invNo, $artNos) {
        $this->assertNull($this->klarna->activatePart($invNo, $artNos));
    }

    public function dataProviderTestInvoiceAmount() {
        return array(
            array(4.56, "123", 456),
            array(1.23, 456, 123),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestInvoiceAmount
     * @param <type> $invNo
     */
    public function testInvoiceAmount($result, $invNo, $amount) {
        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($amount));
        $this->assertEquals($result, $klarnaStub->invoiceAmount($invNo));
    }

    public function dataProviderTestInvoiceAmountException() {
        return array(
            array(""),
            array(null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestInvoiceAmountException
     * @expectedException KlarnaException
     * @param <type> $invNo
     */
    public function testInvoiceAmountException($invNo) {
        $this->assertNull($this->klarna->invoiceAmount($invNo));
    }

    public function dataProviderTestUpdateOrderNo() {
        return array(
            array("123", "456"),
            array(123, "456"),
            array("123", 456),
            array(123, 456),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestUpdateOrderNo
     * @param <type> $invNo
     * @param <type> $estoreOrderNo
     */
    public function testUpdateOrderNo($invNo, $estoreOrderNo) {
        $this->assertTrue($this->klarna->updateOrderNo($invNo, $estoreOrderNo));
    }

    public function dataProviderTestUpdateOrderNoException() {
        $obj = new stdClass();
        return array(
            array("", ""),
            array(null, ""),
//            array($obj, ""),
            array("123", null),
//            array("123", $obj),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestUpdateOrderNoException
     * @expectedException KlarnaException
     * @param <type> $invNo
     * @param <type> $estoreOrderNo
     */
    public function testUpdateOrderNoException($invNo, $estoreOrderNo) {
        $this->assertNull($this->klarna->updateOrderNo($invNo, $estoreOrderNo));
    }

    public function dataProviderTestEmailInvoice() {
        return array(
            array(1234),
            array("1234"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestEmailInvoice
     * @param string $invNo
     */
    public function testEmailInvoice($invNo) {
        $this->assertTrue($this->klarna->emailInvoice($invNo));
    }

    public function dataProviderTestEmailInvoiceException() {
        $obj = new stdClass();
        return array(
            array(""),
            array(null),
//            array($obj),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestEmailInvoiceException
     * @expectedException KlarnaException
     * @param string $invNo
     */
    public function testEmailInvoiceException($invNo) {
        $this->assertNull($this->klarna->emailInvoice($invNo));
    }

    public function dataProviderTestSendInvoice() {
        return array(
            array(123456),
            array("123456"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSendInvoice
     * @param string $invNo
     */
    public function testSendInvoice($invNo) {
        $this->assertTrue($this->klarna->sendInvoice($invNo));
    }

    public function dataProviderTestSendInvoiceException() {
        $obj = new stdClass();
        return array(
            array(""),
            array(null),
//            array($obj),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSendInvoiceException
     * @expectedException KlarnaException
     * @param string $invNo
     */
    public function testSendInvoiceException($invNo) {
        $this->assertNull($this->klarna->sendInvoice($invNo));
    }

    public function dataProviderTestReturnAmount() {
        return array(
            array("1234", "5678", 25, KlarnaFlags::INC_VAT),
            array(1234, 5678, 25.5, KlarnaFlags::NO_FLAG),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestReturnAmount
     * @param <type> $invNo
     * @param <type> $amount
     * @param <type> $vat
     * @param <type> $flags
     */
    public function testReturnAmount($invNo, $amount, $vat, $flags) {
        $this->assertTrue($this->klarna->returnAmount($invNo, $amount, $vat, $flags));
    }

    public function dataProviderTestReturnAmountException() {
        $obj = new stdClass();
        return array(
            array("", "", "", ""),
            array(null, "", "", ""),
//            array($obj, "", "", ""),
            array("123", "", "", ""),
            array("123", null, "", ""),
//            array("123", $obj, "", ""),
            array("123", "456", "", ""),
            array("123", "456", null, ""),
//            array("123", "456", $obj, ""),
            array("123", "456", 25, ""),
            array("123", "456", 25, null),
//            array("123", "456", 25, $obj),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestReturnAmountException
     * @expectedException KlarnaException
     * @param <type> $invNo
     * @param <type> $amount
     * @param <type> $vat
     * @param <type> $flags
     */
    public function testReturnAmountException($invNo, $amount, $vat, $flags) {
        $this->assertNull($this->klarna->returnAmount($invNo, $amount, $vat, $flags));
    }

    public function dataProviderTestCreditInvoice() {
        return array(
            array("123", "1"),
            array(123, 1),
            array(123, false),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestCreditInvoice
     * @param <type> $invNo
     * @param <type> $credNo
     */
    public function testCreditInvoice($invNo, $credNo) {
        $this->assertTrue($this->klarna->creditInvoice($invNo, $credNo));
    }

    public function dataProviderTestCreditInvoiceException() {
        return array(
            array("", ""),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestCreditInvoiceException
     * @expectedException KlarnaException
     * @param <type> $invNo
     * @param <type> $credNo
     */
    public function testCreditInvoiceException($invNo, $credNo) {
        $this->assertNull($this->klarna->creditInvoice($invNo, $credNo));
    }

    public function dataProviderTestCreditPart() {
        $arr1 = array(array("111", "1"));
        $arr2 = array(array(222, 2));
        $arr3 = array(
            array(333, 3),
            array(444, 4),
        );

        return array(
            array("123456", $arr1, "789"),
            array(123456, $arr2, 789),
            array(123456, $arr3, "789"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestCreditPart
     * @param <type> $invNo
     * @param <type> $artNos
     * @param <type> $credNo
     */
    public function testCreditPart($invNo, $artNos, $credNo) {
        foreach ($artNos as $value) {
            $this->klarna->addArtNo($value[1], $value[0]);
        }

        $this->assertTrue($this->klarna->creditPart($invNo, $credNo));
    }

    public function dataProviderTestCreditPartException() {
        $arr1 = array('artno' => "111", 'qty' => "1");
        $arr2 = array();
        return array(
            array("", "", ""),
            array(null, "", ""),
            array("abc", null, ""),
            array("abc", $arr1, null),
            array("abc", $arr2, "0"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestCreditPartException
     * @expectedException KlarnaException
     * @param <type> $invNo
     * @param <type> $artNos
     * @param <type> $credNo
     */
    public function testCreditPartException($invNo, $artNos, $credNo) {
        $this->assertNull($this->klarna->creditPart($invNo, $artNos, $credNo));
    }

    public function dataProviderTestUpdateGoodsQty() {
        return array(
            array("1", "234", "5"),
            array(5, 432, 1),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestUpdateGoodsQty
     * @param <type> $invNo
     * @param <type> $artNo
     * @param <type> $qty
     */
    public function testUpdateGoodsQty($invNo, $artNo, $qty) {
        $this->assertTrue($this->klarna->updateGoodsQty($invNo, $artNo, $qty));
    }

    public function dataProviderTestUpdateGoodsQtyException() {
        return array(
            array("", "", ""),
            array(null, "", ""),
            array("123", "", ""),
            array("123", null, ""),
            array("123", "456", ""),
            array("123", "456", null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestUpdateGoodsQtyException
     * @expectedException KlarnaException
     * @param <type> $invNo
     * @param <type> $artNo
     * @param <type> $qty
     */
    public function testUpdateGoodsQtyException($invNo, $artNo, $qty) {
        $this->assertNull($this->klarna->updateGoodsQty($invNo, $artNo, $qty));
    }

    public function dataProviderUpdateChargeAmount() {
        return array(
            array("100", KlarnaFlags::IS_SHIPMENT, "111"),
            array(200, KlarnaFlags::IS_HANDLING, 222),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderUpdateChargeAmount
     * @param <type> $invNo
     * @param <type> $type
     * @param <type> $newAmount
     */
    public function testUpdateChargeAmount($invNo, $type, $newAmount) {
        $this->assertTrue($this->klarna->updateChargeAmount($invNo, $type, $newAmount));
    }

    public function dataProviderTestUpdateChargeAmountException() {
        return array(
            array("", "", ""),
            array(null, "", ""),
            array("123", "", ""),
            array("123", "abc", ""),
            array("123", null, ""),
            array("123", 999, ""),
            array("123", KlarnaFlags::IS_SHIPMENT, ""),
            array("123", KlarnaFlags::IS_SHIPMENT, "abc"),
            array("123", KlarnaFlags::IS_SHIPMENT, null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestUpdateChargeAmountException
     * @expectedException KlarnaException
     * @param <type> $invNo
     * @param <type> $type
     * @param <type> $newAmount
     */
    public function testUpdateChargeAmountException($invNo, $type, $newAmount) {
        $this->assertNull($this->klarna->updateChargeAmount($invNo, $type, $newAmount));
    }

    public function dataProviderTestInvoiceAddress() {
        $addr1 = new KlarnaAddr();
        $addr1->setFirstName("Karl");
        $addr1->setLastName("Lidin");
        $addr1->setStreet("Junibacksg 42");
        $addr1->setZipCode("23634");
        $addr1->setCity("Hollviken");
        $addr1->setCountry(KlarnaCountry::SE);

        $addr2 = new KlarnaAddr();
        $addr2->isCompany = true;
        $addr2->setCompanyName("Kalle Anka AB");
        $addr2->setStreet("Storgatan 1");
        $addr2->setZipCode("12345");
        $addr2->setCity("Ankeborg");
        $addr2->setCountry(KlarnaCountry::SE);
        return array(
            array($addr1, array("Karl", "Lidin", "Junibacksg 42", "23634", "Hollviken", KlarnaCountry::SE), 1),
            array($addr2, array("", "Kalle Anka AB", "Storgatan 1", "12345", "Ankeborg", KlarnaCountry::SE), "2")
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestInvoiceAddress
     * @param array $result
     * @param string $invNo
     */
    public function testInvoiceAddress($addr, $result, $invNo) {
        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($result));
        $conf = new KlarnaConfig();
        $conf['eid'] = "1029";
        $conf['secret'] = "ALSyKSaQupJWAUK";
        $conf['country'] = KlarnaCountry::SE;
        $conf['language'] = KlarnaLanguage::SV;
        $conf['currency'] = KlarnaCurrency::SEK;
        $conf['mode'] = Klarna::BETA;
        $conf['ssl'] = true;
        $conf['candice'] = true;
        $conf['pcStorage'] = 'json';
        $conf['pcURI'] = dirname(__FILE__) . '/data/beta-pclasses.json';
        $klarnaStub->setConfig($conf);
        $this->assertEquals($addr, $klarnaStub->invoiceAddress($invNo));
    }

    public function dataProviderInvoiceAddressException() {
        return array(
            array(""),
            array(null),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderInvoiceAddressException
     * @expectedException KlarnaException
     * @param int $invNo
     */
    public function testInvoiceAddressException($invNo) {
        $this->assertNull($this->klarna->invoiceAddress($invNo));
    }

    public function dataProviderTestInvoicePartAmount() {
        $arr1 = array(array("1", "111"));
        $arr2 = array(array(2, 222));
        $arr3 = array(
            array(3, 333),
            array("4", "444"),
        );
        return array(
            array("1", $arr1),
            array(2, $arr2),
            array(3, $arr3),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestInvoicePartAmount
     * @param <type> $invNo
     * @param <type> $artNos
     */
    public function testinvoicePartAmount($invNo, $artNos) {
        foreach ($artNos as $value) {
            $this->klarna->addArtNo($value[0], $value[1]);
        }
        $this->assertEquals(0.01, $this->klarna->invoicePartAmount($invNo));
    }

    public function dataProviderCheckOrderStatus() {
        return array(
            array("1"),
            array(1),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderCheckOrderStatus
     * @param int $id
     */
    public function testCheckOrderStatus($id) {
        $this->assertTrue($this->klarna->checkOrderStatus($id));
    }

    public function dataProviderCheckOrderStatusException() {
        return array(
            array(""),
            array(null),
            array(11, 99),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderCheckOrderStatusException
     * @expectedException KlarnaException
     * @param int $id
     */
    public function testCheckOrderStatusException($id, $type = 0) {
        $this->assertNull($this->klarna->checkOrderStatus($id, $type));
    }

    /**
     * @group allPHP
     */
    public function testGetCustomerNo() {
        $klarnaMock = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaMock->expects($this->any())->method('xmlrpc_call')->will($this->returnValue(12345));
        $this->assertEquals(12345, $klarnaMock->getCustomerNo('430415-8399', KlarnaEncoding::PNO_SE));
    }

    /**
     * @group allPHP
     */
    public function testSetCustomerNo() {
        $klarnaMock = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaMock->expects($this->any())->method('xmlrpc_call')->will($this->returnValue('ok'));
        $this->assertTrue($klarnaMock->setCustomerNo("430415-8399", 12345, KlarnaEncoding::PNO_SE));
    }

    /**
     * @group allPHP
     */
    public function testCustomerNoException(){
        $this->setExpectedException('KlarnaException');
        $this->assertNull($this->klarna->setCustomerNo("430415-8399", ""));
        $this->assertNull($this->klarna->getCustomerNo("430415-8399", ""));
    }

    /**
     * @group allPHP
     */
    public function testRemoveCustomerNo() {
        $klarnaMock = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaMock->expects($this->any())->method('xmlrpc_call')->will($this->returnValue('ok'));
        $this->assertTrue($klarnaMock->removeCustomerNo(12345));
        $this->setExpectedException('KlarnaException');
        $this->klarna->removeCustomerNo("");
    }

    /**
     * @group allPHP
     */
    public function testUpdateEmail() {
        $klarnaMock = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaMock->expects($this->any())->method('xmlrpc_call')->will($this->returnValue('ok'));
        $this->assertTrue($klarnaMock->updateEmail("430415-8399", "karl.lidin@klarna.com"));
    }

    /**
     * @group allPHP
     */
    public function testUpdateNotes() {
        $klarnaMock = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaMock->expects($this->any())->method('xmlrpc_call')->will($this->returnValue(TRUE));
        $this->assertTrue($klarnaMock->updateNotes("12345", "Notes"));
        $this->assertTrue($klarnaMock->updateNotes("12345", 12345));
    }

    public function dataProviderPClassTypes() {
        return array(
            array("json"),
            array("xml"),
            array("sql"),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderPClassTypes
     * @param string $type
     */
    public function testFetchPClasses($type) {
        $pcArray = array(
            array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array("362", "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array("112", "12 mn", 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("137", "6 mn", 6, 195 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("136", "3 mn", 3, 95 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("665", "Handla nu - Betala i Mars", 0, 29 * 100, 0, 0, 1 * 100, 209, 2, "2030-05-01"),
            array("666", "300 SEK/mn", 0, 0, 29 * 100, 0, 1000 * 100, 209, 3, "2030-05-01"),
        );
        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.fetchPClasses";
        }
        else {
            $pcURI = vfsStream::url('testDir/fetchPClasses.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $this->assertNull($klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency()));
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testFetchPClassesException() {
        $klarna = new Klarna();
        $this->assertNull($klarna->fetchPClasses($klarna->getCountry(), $klarna->getLanguage(), $klarna->getCurrency()));
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderPClassTypes
     * @param string $type
     */
    public function testGetPClasses($type) {
        $pcArray = array(
            array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array("362", "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array("112", "12 mn", 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("137", "6 mn", 6, 195 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("136", "3 mn", 3, 95 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("665", "Handla nu - Betala i Mars", 0, 29 * 100, 0, 0, 1 * 100, 209, 2, "2030-05-01"),
            array("666", "300 SEK/mn", 0, 0, 29 * 100, 0, 1000 * 100, 209, 3, "2030-05-01"),
        );

        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.getPClasses";
        }
        else {
            $pcURI = vfsStream::url('testDir/getPClasses.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());
        $this->assertInternalType("array", $klarnaStub->getPClasses());
        $newArr = array();
        $this->assertThat(
                $newArr,
                $this->logicalNot(
                        $this->equalTo($klarnaStub->getPClasses()))
        );
    }

    public function dataProviderTestGetPClassesException() {
        return array(
            //array("json", TRUE, FALSE),
            array("json", FALSE, TRUE),
            //array("xml", TRUE, FALSE),
            array("xml", FALSE, TRUE),
            //array("sql", TRUE, FALSE),
            array("sql", FALSE, TRUE),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetPClassesException
     * @expectedException KlarnaException
     */
    public function testGetPClassesException($type, $conf = TRUE, $fetch = TRUE) {
        $pcArray = array(
            array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array("362", "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
        );

        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.getPClassesException";
        }
        else {
            $pcURI = vfsStream::url('testDir/getPClassesException.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        /* if ($conf) {
          $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
          if ($fetch ) $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());
          else $klarnaStub->clearPClasses();
          } */
        $this->assertNull($klarnaStub->getPClasses());
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderPClassTypes
     * @param string $type
     */
    public function testGetPclass($type) {
        $pcArray = array(
            array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array("362", "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array("112", "12 mn", 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("137", "6 mn", 6, 195 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("136", "3 mn", 3, 95 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("665", "Handla nu - Betala i Mars", 0, 29 * 100, 0, 0, 1 * 100, 209, 2, "2030-05-01"),
            array("666", "300 SEK/mn", 0, 0, 29 * 100, 0, 1000 * 100, 209, 3, "2030-05-01"),
        );

        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.getPClass";
        }
        else {
            $pcURI = vfsStream::url('testDir/getPClass.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());
        $pclass1 = new KlarnaPClass(array(1029, "136", Klarna::num_htmlentities("3 mn"), 3, 95, 29, 0, 1000, 209, 0, "1903816800"));
        $pclass2 = new KlarnaPclass(array(1029, "137", Klarna::num_htmlentities("6 mn"), 6, 195, 29, 0, 1000, 209, 0, "1903816800"));
        $this->assertEquals($pclass1, $klarnaStub->getPClass(136));
        $this->assertEquals($pclass2, $klarnaStub->getPClass("137"));
    }

    public function dataProviderTestGetPclassException() {
        return array(
            array("xml", ""),
            array("xml", null),
            array("xml", "abc"),
            array("xml", "390", FALSE),
            array("xml", "390", TRUE, FALSE),
            array("json", ""),
            array("json", null),
            array("json", "abc"),
            array("json", "390", FALSE),
            array("json", "390", TRUE, FALSE),
            array("sql", ""),
            array("sql", null),
            array("sql", "abc"),
            array("sql", "390", FALSE),
            array("sql", "390", TRUE, FALSE),
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestGetPclassException
     * @expectedException KlarnaException
     */
    public function testGetPclassException($type, $id, $conf = TRUE, $fetch = TRUE) {
        $pcArray = array(
            array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array("362", "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
        );

        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.getPClassException";
        }
        else {
            $pcURI = vfsStream::url('testDir/getPClassException.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        if ($conf) {
            $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
            if ($fetch )$klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());
            else $klarnaStub->clearPClasses();
        }
        $this->assertNull($klarnaStub->getPclass($id));
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderPClassTypes
     * @param string $type
     */
    public function testSortPclasses($type) {
        $pcArray1 = array(
            array(362, "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array(112, "12 mn", 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array(136, "3 mn", 3, 95 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array(390, "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array(137, "6 mn", 6, 195 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
        );
        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.sortPClasses";
        }
        else {
            $pcURI = vfsStream::url('testDir/sortPClasses.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray1));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());

        $pcArray = $klarnaStub->getPClasses();
        $klarnaStub->sortPClasses($pcArray);

        $pcArray2 = array(
            new KlarnaPClass(array("1029", "390", "Konto", "24", "0", "29", "19.5", "1", "209", "1", "1903816800")),
            new KlarnaPClass(array("1029", "362", Klarna::num_htmlentities("24 mn"), "24", "295", "29", "9.95", "1000", "209", "0", "1903816800")),
            new KlarnaPClass(array("1029", "112", Klarna::num_htmlentities("12 mn"), "12", "295", "29", "0", "1000", "209", "0", "1903816800")),
            new KlarnaPClass(array("1029", "137", Klarna::num_htmlentities("6 mn"), "6", "195", "29", "0", "1000", "209", "0", "1903816800")),
            new KlarnaPClass(array("1029", "136", Klarna::num_htmlentities("3 mn"), "3", "95", "29", "0", "1000", "209", "0", "1903816800")),
        );

        $this->assertEquals($pcArray2, $pcArray);
    }

    public function dataProviderTestSortPClassesNoDescription() {
        $pcArray1 = array(
            array(362, null, 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array(112, null, 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
        );
        $pcArray2 = array(
            array(362, null, 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array(112, "12 mn", 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
        );
        $pcArray3 = array(
            array(362, "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array(112, null, 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
        );
        $pc1 = new KlarnaPClass();
        $pc1->setId(362);
        $pc1->setDescription(null);
        $pc1->setMonths(24);
        $pc1->setStartFee(295);
        $pc1->setInvoiceFee(29);
        $pc1->setInterestRate(9.95);
        $pc1->setMinAmount(1000);
        $pc1->setType(0);
        $pc1->setCountry(KlarnaCountry::SE);
        $pc1->setEid(1029);
        $pc1->setExpire("1903816800");

        $pc2 = new KlarnaPClass();
        $pc2->setId(112);
        $pc2->setDescription(null);
        $pc2->setMonths(12);
        $pc2->setStartFee(295);
        $pc2->setInvoiceFee(29);
        $pc2->setInterestRate(0);
        $pc2->setMinAmount(1000);
        $pc2->setType(0);
        $pc2->setCountry(KlarnaCountry::SE);
        $pc2->setEid(1029);
        $pc2->setExpire("1903816800");

        $pc3 = new KlarnaPClass(array("1029", 362, Klarna::num_htmlentities("24 mn"), 24, 295, 29, 9.95, 1000, 209, 0, "1903816800"));
        $pc4 = new KlarnaPClass(array("1029", 112, Klarna::num_htmlentities("12 mn"), 12, 295, 29, 0, 1000, 209, 0, "1903816800"));
        $result1 = array($pc1, $pc2);
        $result2 = array($pc4, $pc1);
        $result3 = array($pc3, $pc2);
        return array(
            array($result1, "json", $pcArray1),
            array($result2, "json", $pcArray2),
            array($result3, "json", $pcArray3),
            array($result1, "xml", $pcArray1),
            array($result2, "xml", $pcArray2),
            array($result3, "xml", $pcArray3),
            array($result1, "sql", $pcArray1),
            array($result2, "sql", $pcArray2),
            array($result3, "sql", $pcArray3),
        );
    }

    /**
     * @group allPHP
     * @todo sortPclassesException
     * @dataProvider dataProviderTestSortPClassesNoDescription
     */
    public function testSortPClassesNoDescription($result, $type, $pcArray) {
        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.sortPClassesException";
        }
        else {
            $pcURI = vfsStream::url('testDir/sortPClassesException.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());

        $pcArray = $klarnaStub->getPClasses();
        $klarnaStub->sortPClasses($pcArray);

        $this->assertEquals($result, $pcArray);
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderPClassTypes
     * @param string $type
     */
    public function testGetCheapestPClass($type) {
        $pcArray = array(
            array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array("362", "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array("112", "12 mn", 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("137", "6 mn", 6, 195 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("136", "3 mn", 3, 95 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("665", "Handla nu - Betala i Mars", 0, 29 * 100, 0, 0, 1 * 100, 209, 2, "2030-05-01"),
            array("666", "300 SEK/mn", 0, 0, 29 * 100, 0, 1000 * 100, 209, 3, "2030-05-01"),
        );

        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.getCheapestPClasses";
        }
        else {
            $pcURI = vfsStream::url('testDir/getCheapestPClass.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());
        $pclass = new KlarnaPClass(array("1029", "390", "Konto", 24, 0, 29, 19.5, 1, 209, 1, 1903816800));
        $this->assertEquals($pclass, $klarnaStub->getCheapestPClass(1000, KlarnaFlags::CHECKOUT_PAGE));
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderPClassTypes
     * @param string $type
     * @expectedException KlarnaException
     */
    public function testGetCheapestPClassInvalid($type) {
        $pcArray = array(
            array("390", "Konto", 24, 0, 29 * 100, 19.5 * 100, 1 * 100, 209, 1, "2030-05-01"),
            array("362", "24 mn", 24, 295 * 100, 29 * 100, 9.95 * 100, 1000 * 100, 209, 0, "2030-05-01"),
            array("112", "12 mn", 12, 295 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("137", "6 mn", 6, 195 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("136", "3 mn", 3, 95 * 100, 29 * 100, 0, 1000 * 100, 209, 0, "2030-05-01"),
            array("665", "Handla nu - Betala i Mars", 0, 29 * 100, 0, 0, 1 * 100, 209, 2, "2030-05-01"),
            array("666", "300 SEK/mn", 0, 0, 29 * 100, 0, 1000 * 100, 209, 3, "2030-05-01"),
        );

        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.getCheapestPClasses";
        }
        else {
            $pcURI = vfsStream::url('testDir/getCheapestPClass.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());

        $klarnaStub -> getCheapestPClass("invalid", KlarnaFlags::CHECKOUT_PAGE);
    }

    public function dataProviderTestSavePClassExceptions() {
        $pcArray = array(array("666", Klarna::num_htmlentities("300 SEK/mn"), "0", "0", "29", "0", "1000", "209", "3", "2030-05-01"));
        $array = array();

        $f = vfsStream::newFile('testDir/pclassExceptionsNone.json', 0000);
        $f->setContent("test");

        $f = vfsStream::newFile('testDir/pclassExceptionsReadOnly.xml', 0444);
        $f->setContent("test");

        return array(
            array("sql", "pcUri", $pcArray), //Faulty pcURI
            array("sql", "test@127.0.0.1:3306/APITest.pclassExceptions", $pcArray), //Missing user field
            //array("sql", "user:passwd@127.0.0.1:3306/APITest.pclassExceptions", $pcArray), //Wrong user information
            //array("sql", "none:none@127.0.0.1:3306/Nothing.pclassExceptions", $pcArray), //User with no permissions.
            //array("sql", "test:test@127.0.0.1:3306/APITest.pclassExceptionsFaultyPclass", $array), //Faulty pclass
            //array("json", dirname(__FILE__) . '/data/pclassExceptionsReadOnly.json', $pcArray), //File with read-only permission
            array("json", vfsStream::path('testDir/pclassExceptionsNone.json'), $pcArray), //File with no permission
            array("json", dirname(__FILE__) . '/data/pclassExceptionsFaultyPclass.json', $array), //Faulty pclass
            array("xml", vfsStream::path('testDir/pclassExceptionsReadOnly.xml'), $pcArray), //File with read-only permission
            array("xml", vfsStream::path('testDir/pclassExceptionsNone.json'), $pcArray), //File with no permission
            //array("xml", dirname(__FILE__) . '/data/pclassExceptionsFaultyPclass.json', $array), //Faulty pclass
        );
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderTestSavePClassExceptions
     * @expectedException KlarnaException
     * @param string $type
     * @param string $pcURI
     */
    public function testSavePClassExceptions($type, $pcURI, $pcArray) {
        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $this->assertNull($klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency()));
    }

    /**
     * @group allPHP
     * @dataProvider dataProviderPClassTypes
     * @param string $type
     */
    public function testClearPClasses($type) {
        $pcArray = array(array("666", Klarna::num_htmlentities("300 SEK/mn"), "0", "0", "29", "0", "1000", "209", "3", "2030-05-01"));

        $pcURI = "";
        if ($type == "sql") {
            $pcURI = "test:test@pdo:sqlite::memory:/temp.clearPClasses";
        }
        else {
            $pcURI = vfsStream::url('testDir/clearPClasses.' . $type);
        }

        $klarnaStub = $this->getMock('Klarna', array('xmlrpc_call'));
        $klarnaStub->config(1029, "ALSyKSaQupJWAUK", KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, $type, $pcURI);
        $klarnaStub->setSessionID(0, "sid");
        $klarnaStub->expects($this->any())->method('xmlrpc_call')->will($this->returnValue($pcArray));
        $klarnaStub->fetchPClasses($klarnaStub->getCountry(), $klarnaStub->getLanguage(), $klarnaStub->getCurrency());
        $this->assertNull($klarnaStub->clearPClasses());
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testClearPClassesException() {
        $klarna = new Klarna();
        $this->assertNull($klarna->clearPClasses());
    }

    /**
     * @group allPHP
     */
    public function testCheckoutHTML() {
        $this->assertInternalType("string", $this->klarna->checkoutHTML());
        $newString = "";
        $this->assertThat(
                $newString,
                $this->logicalNot(
                        $this->equalTo($this->klarna->checkoutHTML()))
        );
    }

    /**
     * @group allPHP
     * @expectedException KlarnaException
     */
    public function testCheckoutHTMLException() {
        $klarna = new Klarna();
        $this->assertNull($klarna->checkoutHTML());
    }

    /**
     * @todo Test private/protected fuctions?
     */
    public function testXmlrpc_Call() {
        $this->markTestIncomplete('Test is incomplete');
        $method = new ReflectionMethod('Klarna', 'xmlrpc_call');
        $method->setAccessible(TRUE);
        $this->assertEquals('blah', $method->invoke(new Klarna));
    }

    /**
     * @todo Test private/protected attributes
     */
    public function testPrivateAttribute() {
        $this->markTestIncomplete('This test is incomplete');
        $this->assertAttributeEquals(
                'baz', /* expected value */
                'xmlrpc', /* attribute name */
                new Klarna /* object         */
        );
    }

    /**
     * @group allPHP
     */
    public function testColon() {
        $this->assertEquals("test:ing", $this->klarna->colon("test", "ing"));
    }

    /**
     * @group allPHP
     */
    public function testPipe() {
        $this->assertEquals("test|ing", $this->klarna->pipe("test", "ing"));
    }

    /**
     * @group allPHP
     */
    public function testNum_htmlentities() {
        $this->assertEquals("&#229;&#228;&#246;", Klarna::num_htmlentities(""));
    }

    /**
     * @group allPHP
     */
    public function testPrintDebug() {
        Klarna::$debug = true;
        ob_start();
        $this->assertNull($this->klarna->printDebug("msg", "debugg"));
        ob_end_clean();
        Klarna::$debug = false;
    }

    /**
     * @group allPHP
     */
    public function testNumericSecret() {
        $k = new Klarna();

        //Should not throw an exception
        $k->config(1029, 123456, KlarnaCountry::SE, KlarnaLanguage::SV, KlarnaCurrency::SEK, Klarna::BETA, "xml", dirname(__FILE__) . '/pclass.xml');
    }

    /**
     * @group allPHP
     */
    public function testNonNumericConfig() {
         $k = new Klarna();

        //Should not throw an exception
        $k->config(1029, 123456, 'se', 'sv', 'sek', Klarna::BETA, "xml", dirname(__FILE__) . '/pclass.xml');
    }

    /**
     * @group allPHP
     */
    public function testIPs() {
        $ip = '129.1.1.1';
        $_SERVER['REMOTE_ADDR'] = $ip;
        $proxy = '150.1.1.1';
        $_SERVER['HTTP_X_FORWARDED_FOR'] = $proxy . ',' . $ip;

        $k = new Klarna();
        $this->assertEquals($ip, $k->getClientIP());

        Klarna::$x_forwarded_for = true;
        $this->assertEquals($proxy, $k->getClientIP());

        $_SERVER['HTTP_X_FORWARDED_FOR'] = $proxy;
        $this->assertEquals($proxy, $k->getClientIP());
    }
}

?>
