<?php
//~ require_once 'vfsStream/vfsStream.php';
//~ require_once 'PHPUnit/Extensions/Database/TestCase.php';
require_once(DIR_WS_INCLUDES.'external/klarna/api/klarnapclass.php');
require_once(DIR_WS_INCLUDES.'external/klarna/api/pclasses/sqlstorage.class.php');
require_once('../jsonfileiterator.php');

/**
 * Test class for SQLStorage.
 * Generated by PHPUnit on 2011-07-22 at 10:56:57.
 */
class SQLStorageTest extends PHPUnit_Extensions_Database_TestCase
{
    // only instantiate pdo once for test clean-up/fixture load
    static private $pdo = null;

    // only instantiate PHPUnit_Extensions_Database_DB_IDatabaseConnection once per test
    private $conn = null;

    /**
     * @var SQLStorage
     */
    protected $object;

    public static function setUpBeforeClass()
    {
        date_default_timezone_set('Europe/Stockholm');
    }

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->uri = 'test:test@pdo:sqlite::memory:/temp.pclasses';

        $this->object = new ExposedSQLStorage();
        $this->db = $this->getConnection();
        $this->object->setConnection(self::$pdo);
        $this->expire = 1903816800;
        $this->pclass = new KlarnaPClass(
            array(
                'eid' => 2,
                'id' => 666,
                'description' => 'desc_pclass',
                'months' => 12,
                'startfee' => 0,
                'invoicefee' => 0,
                'interestrate' => 12.2,
                'minamount' => 1,
                'country' => 81,
                'type' => 2,
                'expire' => $this->expire
            )
        );
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
        $this->object = null;
    }

    /**
     * @return PHPUnit_Extensions_Database_DB_IDatabaseConnection
     */
    public function getConnection()
    {
        if ($this->conn === null) {
            if (self::$pdo == null) {
                self::$pdo = new PDO('sqlite::memory:', 'test', 'test');
            }
            $this->conn = $this->createDefaultDBConnection(self::$pdo, ':memory:');
        }

        return $this->conn;
    }

    /**
     * @return PHPUnit_Extensions_Database_DataSet_IDataSet
     */
    public function getDataSet($file = 'pclassDataSet.yml') {
        return new PHPUnit_Extensions_Database_DataSet_YamlDataSet(
            dirname(dirname(__FILE__))."/data/{$file}"
        );
    }


    /**
     * @group allPHP
     */
    public function testGetConnection() {
        $this->object->setConnection(null);
        $this->object->testGetConnection($this->uri);

        //Code coverage for "already have connection"
        $this->object->testGetConnection($this->uri);
    }

    /**
     * @group allPHP
     * @dataProvider jsonURI
     */
    public function testURI($uri, $user, $passwd, $addr, $db, $table)
    {
        //$addr is also $dsn
        $arr = $this->object->testURI($uri);

        //Make sure no field is empty
        $this->assertNotEmpty($arr[0]);
        $this->assertNotEmpty($arr[1]);
        $this->assertNotEmpty($arr[2]);
        $this->assertNotEmpty($arr[3]);
        $this->assertNotEmpty($arr[4]);
        $this->assertNotEmpty($arr[5]);

        //Compare results.
        $this->assertEquals($arr[0], $uri);
        $this->assertEquals($arr[1], $user);
        $this->assertEquals($arr[2], $passwd);
        $this->assertEquals($arr[3], $addr);
        $this->assertEquals($arr[4], $db);
        $this->assertEquals($arr[5], $table);
    }


    /**
     * @group allPHP
     * @dataProvider jsonInvalidURI
     * @expectedException Exception
     */
    public function testInvalidURI($uri, $user, $passwd, $addr, $db, $table)
    {
        $arr = $this->object->testURI($uri);
    }

    /**
     * @group allPHP
     * @depends testURI
     */
    public function testSave()
    {
        $this->object->addPClass($this->pclass);
        $this->object->save($this->uri);

        //Compare the dataset with the DB.
        $ds = new PHPUnit_Extensions_Database_DataSet_QueryDataSet($this->getConnection());
        $ds->addTable('pclasses');
        $this->assertDataSetsEqual($this->getDataSet(), $ds);
    }

    /**
     * @group allPHP
     * @depends testSave
     */
    public function testLoad()
    {
        $this->object->load($this->uri);

        $pclass = $this->object->getPClass($this->pclass->getId(), $this->pclass->getEid(), $this->pclass->getCountry());
        $this->assertEquals($this->pclass, $pclass);
    }

    /**
     * @group allPHP
     * @depends testLoad
     */
    public function testClear()
    {
        $this->object->clear($this->uri);

        $this->assertEquals(0, $this->db->getRowCount('pclasses'));
    }

    public function jsonURI()
    {
        return new JSONFileIterator(dirname(dirname(__FILE__)).'/data/dbURIs.json');
    }

    public function jsonInvalidURI()
    {
        return new JSONFileIterator(dirname(dirname(__FILE__)).'/data/dbURIsInvalid.json');
    }
}

/**
 * Extended the SQLStorage to expose the splitURI method.
 */
class ExposedSQLStorage extends SQLStorage
{
    public function setConnection($pdo)
    {
        $this->pdo = $pdo;
    }

    public function testGetConnection($uri) {
        parent::getConnection($uri);
    }

    protected function getConnection($uri)
    {
        $this->splitURI($uri);
        return;
    }

    public function testURI($uri)
    {
        return $this->splitURI($uri);
    }
}
